<?php


namespace Modules\Auction\Entities;

use Elasticquent\ElasticquentTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Core\Entities\Attachment;


class AuctionCategory extends Model
{
    use ElasticquentTrait;
    use SoftDeletes;
    protected $fillable = ['title', 'description'];
    protected $appends = ['attachments'];
    public function getAttachmentsAttribute()
    {
        return $this->attachments()->get();
    }
    public function auction()
    {
        return $this->hasMany(Auction::class ,'tender_category_id');
    }
    function attachments(){
        return $this->morphMany(Attachment::class,'attachmentable');
    }
    public $adminFields=[
        'image'=>[
            'type'=>'photo',
            'fa_name'=>'عکس ',
            'col'=>12,
            'required'=>false,
            'data'=>[]
        ],
        'title'=>[
            'type'=>'string',
            'fa_name'=>'عنوان',
            'col'=>12,
            'required'=>true,
            'data'=>[]
        ],
        'description'=>[
            'type'=>'string',
            'fa_name'=>'توضیحات',
            'col'=>12,
            'required'=>true,
            'data'=>[]
        ],
    ];
}
