@extends('core::layouts.master')
@section('head')


    <link href="{{Module::asset('core:node_modules/nestable/jquery-nestable.css')}}" rel="stylesheet"/>
    <link rel="stylesheet" href="{{Module::asset('core:node_modules/select2/dist/css/select2.min.css')}}"/>
    <link rel="stylesheet" href="{{Module::asset('core:node_modules/select2-bootstrap-theme/dist/select2-bootstrap.min.css')}}"/>
    <link rel="stylesheet" href="{{Module::asset('core:node_modules/icheck/skins/all.css')}}"/>
    <link rel="stylesheet" href="{{Module::asset('core:node_modules/jquery-tags-input/dist/jquery.tagsinput.min.css')}}">
    <link rel="stylesheet" href="{{Module::asset('core:node_modules/dropify/dist/css/dropify.min.css')}}">
    <link rel="stylesheet" href="{{Module::asset('core:css/persian-datepicker.min.css')}}">

@endsection
@section('content')
    <div class="content-wrapper">
        @include('core::layouts.breadcrumb')

        <div class="row">
            <div class="col-12 grid-margin">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6"><h4 class="card-title">افزودن فیلد اضافی</h4></div>
                            <div class="col-md-6 text-left"><a href="/extra_news_list" class="btn btn-warning">بازگشت به لیست</a></div>
                        </div>
                        <div class="row mt-5">
                            <div class="col-md-12">
                                    <div class="form-group pt-3">
                                        <label>انتخاب نوع فیلد</label>
                                        <div class="mt-1">
                                            <select class="js-example-basic-single w-100" id="chooseField">
                                                <option value="text">متن کوتاه</option>
                                                <option value="text-box">متن بلند</option>
                                                <option value="select">فهرست</option>
                                                <option value="switch">دکمه سوئیچی</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="extra-content" style="margin-right: 0">
                                        <div id="text" class="extraElements">
                                            <form action="{{route('admin.'.$route_action,isset($params)?$params:[])}}" method="post">
                                                @csrf
                                                <input type="hidden" name="category_id" value="{{$id}}" >
                                                <input type="hidden" name="type" value="text" >
                                            <h4>تعریف فیلد های اضافی متن کوتاه</h4>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group pt-5">
                                                        <label for="text-title">عنوان </label>
                                                        <input name="title" type="text" class="form-control mt-1" id="text-title" placeholder="عنوان جهت نمایش در پنل مدیریت">
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group pt-5">
                                                        <label for="text-placeholder">متن placeholder </label>
                                                        <input name="placeholder" type="text" class="form-control mt-1" id="text-placeholder" placeholder="متن placeholder ">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group pt-3">
                                                        <label for="text-name">نام فیلد </label>
                                                        <input type="text" class="form-control mt-1" id="text-name" placeholder="نام فیلد (به لاتین)">
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group pt-3">
                                                        <label for="text-value">مقدار پیشفرض</label>
                                                        <input name="value" type="text" class="form-control mt-1" id="text-value" placeholder="مقدار پیشفرض">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group pt-3">
                                                        <label for="text-col">عرض از 12</label>
                                                        <input name="col" type="number" class="form-control mt-1" id="text-col" placeholder="عرض از 12">
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group pt-3">
                                                        <label for="text-position">موقعیت</label>
                                                        <input name="position" type="number" class="form-control mt-1" id="text-position" placeholder="موقعیت">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="form-group pt-3">
                                                        <label for="text-desc">توضیحات</label>
                                                        <textarea name="description" class="form-control mt-1" id="text-desc" placeholder="توضیحات"></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group pt-3">
                                                        <label>فیلد اجباری</label>
                                                        <div class="mt-1">
                                                            <label class="switch"><input name="required" type="hidden" value="0">
                                                                <input name="required" type="checkbox" checked value="1">
                                                                <span class="slider round"></span>
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group pt-3">
                                                        <label>نمایش</label>
                                                        <div class="mt-1">
                                                            <label class="switch"><input name="display" type="hidden" value="0">
                                                                <input name="display" type="checkbox" checked value="1">
                                                                <span class="slider round"></span>
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group pt-3">
                                                            <label>مهم</label>
                                                            <div class="mt-1">
                                                                <label class="switch"><input name="important" type="hidden" value="0">
                                                                    <input name="important" type="checkbox" checked value="1">
                                                                    <span class="slider round"></span>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group pt-3">
                                                            <label>فنی</label>
                                                            <div class="mt-1">
                                                                <label class="switch"><input name="technical" type="hidden" value="0">
                                                                    <input name="technical" type="checkbox" checked value="1">
                                                                    <span class="slider round"></span>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <hr />
                                            <div class="row">
                                                <div class="col-md-6"><h5>راهنما</h5></div>
                                                <div class="col-md-6 text-left"><i class="icon-info" data-toggle="popover" title="راهنمای فیلد ها" data-content="شما می توانید برای سهولت استفاده از فیلد های اضافه توسط کاربران ادمین برای فیلد اضافه ایجاد شده مانند همین راهنما، توضیحات لازم را وارد نمایید."></i></div>
                                            </div>
                                            <div class="form-group pt-3">
                                                <label for="text-help-title">عنوان راهنما </label>
                                                <input type="text" class="form-control mt-1" id="text-help-title" placeholder="عنوان راهنما " name="guide_title">
                                            </div>
                                            <div class="form-group pt-3">
                                                <label for="text-help-desc">متن راهنما </label>
                                                <input type="text" class="form-control mt-1" id="text-help-desc" placeholder="متن راهنما " name="guide_description">
                                            </div>
                                            <div class="form-group pt-3 text-left">
                                                <button type="submit" class="btn btn-success">ثبت</button>
                                            </div>
                                            </form>
                                        </div>
                                        <div id="text-box" style="display: none" class="extraElements">
                                            <form action="{{route('admin.'.$route_action,isset($params)?$params:[])}}" method="post">
                                                @csrf
                                                <input type="hidden" name="category_id" value="{{$id}}" >
                                                <input type="hidden" name="type" value="text-box" >
                                            <h4>تعریف فیلد های اضافی متن بلند</h4>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group pt-5">
                                                        <label for="text-box-title">عنوان </label>
                                                        <input name="title" type="text" class="form-control mt-1" id="text-box-title" placeholder="عنوان جهت نمایش در پنل مدیریت ">
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group pt-5">
                                                        <label for="text-box-placeholder">متن placeholder </label>
                                                        <input name="placeholder" type="text" class="form-control mt-1" id="text-box-placeholder" placeholder="متن placeholder ">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group pt-3">
                                                        <label for="text-box-name">نام فیلد </label>
                                                        <input name="" type="text" class="form-control mt-1" id="text-box-name" placeholder="نام فیلد (به لاتین)">
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group pt-3">
                                                        <label for="text-box-value">مقدار پیشفرض</label>
                                                        <input name="value" type="text" class="form-control mt-1" id="text-box-value" placeholder="مقدار پیشفرض">
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group pt-3">
                                                        <label for="text-box-col">عرض از 12</label>
                                                        <input name="col" type="number" class="form-control mt-1" id="text-box-col" placeholder="عرض از 12">
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group pt-3">
                                                        <label for="text-box-position">موقعیت</label>
                                                        <input name="position" type="number" class="form-control mt-1" id="text-box-position" placeholder="موقعیت">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="form-group pt-3">
                                                        <label for="text-box-desc">توضیحات</label>
                                                        <textarea name="description" class="form-control mt-1" id="text-box-desc" placeholder="توضیحات"></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-4">
                                                    <div class="form-group pt-3">
                                                        <label>فیلد اجباری</label>
                                                        <div class="mt-1">
                                                            <label class="switch">
                                                                <input name="required" type="hidden" value="0">
                                                                <input name="required" type="checkbox" checked value="1">
                                                                <span class="slider round"></span>
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="form-group pt-3">
                                                        <label>نمایش</label>
                                                        <div class="mt-1">
                                                            <label class="switch">
                                                                <input name="display" type="hidden" value="0">
                                                                <input name="display" type="checkbox" checked value="1">
                                                                <span class="slider round"></span>
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="form-group pt-3">
                                                        <label>فنی</label>
                                                        <div class="mt-1">
                                                            <label class="switch"><input name="technical" type="hidden" value="0">
                                                                <input name="technical" type="checkbox" checked value="1">
                                                                <span class="slider round"></span>
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <hr />
                                            <div class="row">
                                                <div class="col-md-6"><h5>راهنما</h5></div>
                                                <div class="col-md-6 text-left"><i class="icon-info" data-toggle="popover" title="راهنمای فیلد ها" data-content="شما می توانید برای سهولت استفاده از فیلد های اضافه توسط کاربران ادمین برای فیلد اضافه ایجاد شده مانند همین راهنما، توضیحات لازم را وارد نمایید."></i></div>
                                            </div>
                                            <div class="form-group pt-3">
                                                <label for="text-box-help-title">عنوان راهنما </label>
                                                <input name="guide_title" type="text" class="form-control mt-1" id="text-box-help-title" placeholder="عنوان راهنما ">
                                            </div>
                                            <div class="form-group pt-3">
                                                <label for="text-box-help-desc">متن راهنما </label>
                                                <input name="guide_description" type="text" class="form-control mt-1" id="text-box-help-desc" placeholder="متن راهنما ">
                                            </div>
                                            <div class="form-group pt-3 text-left">
                                                <button type="submit" class="btn btn-success">ثبت</button>
                                            </div>
                                            </form>
                                        </div>
                                        <div id="select" style="display: none" class="extraElements">
                                            <form action="{{route('admin.'.$route_action,isset($params)?$params:[])}}" method="post">
                                                @csrf
                                                <input type="hidden" name="category_id" value="{{$id}}" >
                                                <input type="hidden" name="type" value="select" >
                                            <h4>تعریف فیلد های اضافی فهرست</h4>
                                            <div class="form-group pt-3">
                                                <label for="select-title">عنوان </label>
                                                <input type="text" name="title" class="form-control mt-1" id="select-title" placeholder="عنوان جهت نمایش در پنل مدیریت ">
                                            </div>
                                            <div class="form-group pt-3">
                                                <label for="select-name">نام فیلد </label>
                                                <input type="text" name="" class="form-control mt-1" id="select-name" placeholder="نام فیلد (به لاتین)">
                                            </div>

                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group pt-3">
                                                        <label for="select-col">عرض از 12</label>
                                                        <input name="col" type="number" class="form-control mt-1" id="select-col" placeholder="عرض از 12">
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group pt-3">
                                                        <label for="select-position">موقعیت</label>
                                                        <input name="position" type="number" class="form-control mt-1" id="select-position" placeholder="موقعیت">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="form-group pt-3">
                                                        <label for="select-desc">توضیحات</label>
                                                        <textarea name="description" class="form-control mt-1" id="select-desc" placeholder="توضیحات"></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-4">
                                                    <div class="form-group pt-3">
                                                        <label>فیلد اجباری</label>
                                                        <div class="mt-1">
                                                            <label class="switch">
                                                                <input name="required" type="hidden" value="0">
                                                                <input name="required" type="checkbox" checked value="1">
                                                                <span class="slider round"></span>
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="form-group pt-3">
                                                        <label>نمایش</label>
                                                        <div class="mt-1">
                                                            <label class="switch">
                                                                <input name="display" type="hidden" value="0">
                                                                <input name="display" type="checkbox" checked value="1">
                                                                <span class="slider round"></span>
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="form-group pt-3">
                                                        <label>فنی</label>
                                                        <div class="mt-1">
                                                            <label class="switch"><input name="technical" type="hidden" value="0">
                                                                <input name="technical" type="checkbox" checked value="1">
                                                                <span class="slider round"></span>
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div id="select-options">
                                                <div class="row">
                                                    <div class="col-md-6"><h5>افزودن زیر دسته</h5></div>
                                                    <div class="col-md-6 text-left">
                                                        <a href="javascript:void(0);" class="btn btn-info" id="add-option">افزودن</a>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="form-group pt-3">
                                                            <label>عنوان </label>
                                                            <input type="text" class="form-control mt-1" name="optionsTitle[]" placeholder="عنوان ">
                                                        </div>
                                                    </div>

                                                </div>
                                            </div>

                                            <hr />
                                            <div class="row">
                                                <div class="col-md-6"><h5>راهنما</h5></div>
                                                <div class="col-md-6 text-left"><i class="icon-info" data-toggle="popover" title="راهنمای فیلد ها" data-content="شما می توانید برای سهولت استفاده از فیلد های اضافه توسط کاربران ادمین برای فیلد اضافه ایجاد شده مانند همین راهنما، توضیحات لازم را وارد نمایید."></i></div>
                                            </div>
                                            <div class="form-group pt-3">
                                                <label for="select-help-title">عنوان راهنما </label>
                                                <input type="text" name="guide_title" class="form-control mt-1" id="select-help-title" placeholder="عنوان راهنما ">
                                            </div>
                                            <div class="form-group pt-3">
                                                <label for="select-help-desc">متن راهنما </label>
                                                <input type="text" name="guide_description" class="form-control mt-1" id="select-help-desc" placeholder="متن راهنما ">
                                            </div>
                                            <div class="form-group pt-3 text-left">
                                                <button type="submit" class="btn btn-success">ثبت</button>
                                            </div>
                                            </form>
                                        </div>
                                        <div id="switch" style="display: none" class="extraElements">
                                            <form action="{{route('admin.'.$route_action,isset($params)?$params:[])}}" method="post">
                                                @csrf
                                                <input type="hidden" name="category_id" value="{{$id}}" >
                                                <input type="hidden" name="type" value="switch" >
                                            <h4>تعریف فیلد های اضافی دکمه سوئیچی</h4>
                                            <div class="form-group pt-5">
                                                <label for="switch-title">عنوان </label>
                                                <input type="text" class="form-control mt-1" name="title" id="switch-title" placeholder="عنوان جهت نمایش در پنل مدیریت ">
                                            </div>
                                            <div class="form-group pt-3">
                                                <label for="switch-name">نام فیلد </label>
                                                <input type="text" class="form-control mt-1" name="" id="switch-name" placeholder="نام فیلد (به لاتین)">
                                            </div>

                                            <div class="form-group pt-3">
                                                <label for="switch-value">مقدار پیشفرض</label>
                                                <select class="form-control mt-1" id="switch-value" name="value">
                                                    <option value="1">روشن</option>
                                                    <option value="0">خاموش</option>
                                                </select>
                                            </div>
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group pt-3">
                                                            <label>نمایش</label>
                                                            <div class="mt-1">
                                                                <label class="switch">
                                                                    <input name="display" type="hidden" value="0">
                                                                    <input name="display" type="checkbox" checked value="1">
                                                                    <span class="slider round"></span>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group pt-3">
                                                            <label>فنی</label>
                                                            <div class="mt-1">
                                                                <label class="switch"><input name="technical" type="hidden" value="0">
                                                                    <input name="technical" type="checkbox" checked value="1">
                                                                    <span class="slider round"></span>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <hr />
                                            <div class="row">
                                                <div class="col-md-6"><h5>راهنما</h5></div>
                                                <div class="col-md-6 text-left"><i class="icon-info" data-toggle="popover" title="راهنمای فیلد ها" data-content="شما می توانید برای سهولت استفاده از فیلد های اضافه توسط کاربران ادمین برای فیلد اضافه ایجاد شده مانند همین راهنما، توضیحات لازم را وارد نمایید."></i></div>
                                            </div>
                                            <div class="form-group pt-3">
                                                <label for="switch-help-title">عنوان راهنما </label>
                                                <input type="text" name="guide_title" class="form-control mt-1" id="switch-help-title" placeholder="عنوان راهنما ">
                                            </div>
                                            <div class="form-group pt-3">
                                                <label for="switch-help-desc">متن راهنما </label>
                                                <input type="text" name="guide_description" class="form-control mt-1" id="switch-help-desc" placeholder="متن راهنما ">
                                            </div>
                                            <div class="form-group pt-3 text-left">
                                                <button type="submit" class="btn btn-success">ثبت</button>
                                            </div>
                                            </form>
                                        </div>
                                    </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')

    <script src="{{Module::asset('core:node_modules/jquery-bar-rating/dist/jquery.barrating.min.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/raphael/raphael.min.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/jquery-sparkline/jquery.sparkline.min.js')}}"></script>
    <script src="{{Module::asset('core:js/jquery-sortable.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/nestable/jquery.nestable.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/select2/dist/js/select2.min.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/icheck/icheck.min.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/jquery-tags-input/dist/jquery.tagsinput.min.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/dropify/dist/js/dropify.min.js')}}"></script>
    <script src="{{Module::asset('core:js/persian-date.min.js')}}"></script>
    <script src="{{Module::asset('core:js/persian-datepicker.min.js')}}"></script>
    <script>
        $('.persianDate').persianDatepicker({
            autoClose: true,
            onSelect:function(val){
                $('.persianDate').val(new persianDate(val).toCalendar('gregorian').toLocale('en').format('YYYY-MM-DD'))
            }
        });
        $('.persianDateTime').persianDatepicker({
            autoClose: true,
            onSelect:function(val){
                $('.persianDateTime').val(new persianDate(val).toCalendar('gregorian').toLocale('en').format('YYYY-MM-DD hh:mm:ss'))
            },
            timePicker: {
                enabled: true,
                meridiem: {
                    enabled: true
                }
            }});

    </script>
    <script src="{{Module::asset('core:ckeditor/ckeditor.js')}}"></script>

    <script src="{{Module::asset('core:js/iCheck.js')}}"></script>

    <script>


        if($('#xeditor').length){
            CKEDITOR.replace('xeditor');
        }
        $(function () {
            $(".js-example-basic-single").select2({dir: 'rtl', placeholder: "انتخاب نشده"});
            $(".js-example-basic-multiple").select2({dir:'rtl',placeholder: "انتخاب نشده"});
            $('#editModal').on('shown.bs.modal', function (e) {
                $(".js-example-basic-single").select2({dir: 'rtl', placeholder: "انتخاب نشده"});
                $(".js-example-basic-multiple").select2({dir:'rtl',placeholder: "انتخاب نشده"});
            })

            $('#tags').tagsInput({
                'width': '100%',
                'height': '100%',
                'interactive': true,
                'defaultText': 'اضافه کردن',
                'removeWithBackspace': true,
                'minChars': 0,
                'maxChars': 20, // if not provided there is no limit
                'placeholderColor': '#666666'
            });

            $('#tags2').tagsInput({
                'width': '100%',
                'height': '100%',
                'interactive': true,
                'defaultText': 'اضافه کردن',
                'removeWithBackspace': true,
                'minChars': 0,
                'maxChars': 20, // if not provided there is no limit
                'placeholderColor': '#666666'
            });
            $('.icon-plus').on('click', function () {
                $('.attachments').append('<div class="pt-3"> <input type="file" class="dropify" /></div>')
                $('.dropify').dropify();
            })
        });
        $(document).on('keyup','#pSearchInput',function(){
            let input = $('#pSearchInput')
            if(input.val().length){
                $('.perm').hide()
                $('div[data-search*='+input.val()+']').show()
            }else{
                $('.perm').show()
            }
        })
    </script>
    <script src="{{Module::asset('core:/js/dropify.js')}}"></script>
    <script>
        $(".js-example-basic-single").select2({dir:'rtl',placeholder: "انتخاب نشده"});
        $('#chooseField').on('change',function () {
            var fieldID = $(this).val();
            $('.extraElements').fadeOut()
            setTimeout(function () {
                $('#'+fieldID).fadeIn()
            },500)
        })
        $('#add-option').on('click',function () {
            $('#select-options').append('<div class="row"><div class="col-md-12"><div class="form-group pt-3"><label>عنوان </label><input type="text" class="form-control mt-1" name="optionsTitle[]" placeholder="عنوان "></div> </div></div>')
        })


        if ($("#ul-slider-1").length) {
            var bigValueSlider = document.getElementById('ul-slider-1'),
                bigValueSpan = document.getElementById('huge-value');

            noUiSlider.create(bigValueSlider, {
                start: 100,
                step: 10,
                direction: 'rtl',
                connect: [true, false],
                range: {
                    min: 10,
                    max: 100
                }
            });
            bigValueSlider.noUiSlider.on('update', function(values, handle) {
//                  console.log(range[Math.floor(values);

                bigValueSpan.innerHTML = Math.floor(values);
            });
        }
        if ($("#ul-slider-2").length) {
            var bigValueSlider2 = document.getElementById('ul-slider-2'),
                bigValueSpan2 = document.getElementById('huge2-value');

            noUiSlider.create(bigValueSlider2, {
                start: 100,
                step: 10,
                direction: 'rtl',
                connect: [true, false],
                range: {
                    min: 10,
                    max: 100
                }
            });
            bigValueSlider2.noUiSlider.on('update', function(values, handle) {
//                  console.log(range[Math.floor(values);

                bigValueSpan2.innerHTML = Math.floor(values);
            });
        }
        $('#tags').tagsInput({
            'width': '100%',
            'height': '100%',
            'interactive': true,
            'defaultText': 'اضافه کردن',
            'removeWithBackspace': true,
            'minChars': 0,
            'maxChars': 20, // if not provided there is no limit
            'placeholderColor': '#666666'
        });
    </script>
@endsection