<?php

Route::group(['middleware' => ['web','auth','acl'], 'prefix' => 'admin','as' => 'admin'], function()
{
    Route::group(['middleware' => 'web', 'prefix' => 'advertisement', 'namespace' => 'Modules\Advertisement\Http\Controllers' , 'as'=>'.advertisement'], function()
    {
        Route::group(['middleware' => 'web', 'prefix' => 'list','as' => '.list' ], function()
        {
            Route::get('/', 'AdvertisementController@index');
            Route::get('/delete','AdvertisementController@destroy')->name('.delete');
            Route::get('/create','AdvertisementController@add')->name('.create');
            Route::post('store', 'AdvertisementController@store')->name('.store');
            Route::get('/edit/{id}','AdvertisementController@edit')->name('.edit');
            Route::post('update/{id}', 'AdvertisementController@update')->name('.update');
            Route::group(['middleware' => 'web', 'prefix' => 'experience','as' => '.experience'], function()
            {
                Route::get('/{id}','ExperienceController@index');
                Route::get('/delete/{id}','ExperienceController@destroy')->name('.delete');
            });
            Route::group(['middleware' => 'web', 'prefix' => 'report','as' => '.report'], function()
            {
                Route::get('/','ReportController@index');
                Route::get('/delete/{id}','ReportController@destroy')->name('.delete');
            });
            Route::group(['middleware' => 'web', 'prefix' => 'comment','as' => '.comment' ], function()
            {
                Route::get('/{id}','CommentController@index');
                Route::get('/delete/{id}','CommentController@destroy')->name('.delete');
            });
            Route::group(['middleware' => 'web', 'prefix' => 'offer','as' => '.offer' ], function()
            {
                Route::get('/{id}','OfferController@index');
                Route::get('/delete/{id}','OfferController@destroy')->name('.delete');
            });
        });
        Route::group(['middleware' => 'web','prefix' => 'category' , 'as'=>'.category'], function()
        {
            Route::group([ 'prefix' => 'list','as' => '.list'], function()
            {
                Route::get('/', 'CategoriesController@index');
                Route::get('/delete','CategoriesController@destroy')->name('.delete');
                Route::get('/create','CategoriesController@add')->name('.create');
                Route::post('store', 'CategoriesController@store')->name('.store');
                Route::get('/edit','CategoriesController@edit')->name('.edit');
                Route::post('update/{id}','CategoriesController@update')->name('.update');
                Route::group([ 'prefix' => 'items','as' => '.items'], function()
                {


                    Route::get('/{id}', 'CategoriesController@items');
                    Route::get('/delete/{id}','CategoriesController@itemDestroy')->name('.delete');
                    Route::get('/{id}/create','CategoriesController@itemCreate')->name('.create');
                    Route::post('store/{id}', 'CategoriesController@itemStore')->name('.store');
                    Route::get('/edit/{id}','CategoriesController@itemEdit')->name('.edit');
                    Route::post('update/{id}','CategoriesController@itemUpdate')->name('.update');
                    Route::group([ 'prefix' => 'form','as' => '.form'], function()
                    {
                        Route::get('/{id}', 'CategoriesController@itemForm');
                        Route::get('/delete/{id}','CategoriesController@formDestroy')->name('.delete');
                        Route::get('/{id}/create','CategoriesController@formCreate')->name('.create');
                        Route::post('store/{id}', 'CategoriesController@formStore')->name('.store');
                        Route::get('/edit/{id}','CategoriesController@formEdit')->name('.edit');
                        Route::post('update/{id}','CategoriesController@formUpdate')->name('.update');
                    });

                    Route::group([ 'prefix' => 'items','as' => '.items'], function()
                    {
                        Route::get('/{id}', 'CategoriesController@Itemitems');
                        Route::get('/delete/{id}','CategoriesController@ItemitemDestroy')->name('.delete');
                        Route::get('/{id}/create','CategoriesController@ItemitemCreate')->name('.create');
                        Route::post('store/{id}', 'CategoriesController@ItemitemStore')->name('.store');
                        Route::get('/edit/{id}','CategoriesController@ItemitemEdit')->name('.edit');
                        Route::post('update/{id}','CategoriesController@ItemitemUpdate')->name('.update');

                        Route::group([ 'prefix' => 'form','as' => '.form'], function()
                        {
                            Route::get('/{id}', 'CategoriesController@itemForm');
                            Route::get('/delete/{id}','CategoriesController@ItemformDestroy')->name('.delete');
                            Route::get('/{id}/create','CategoriesController@ItemformCreate')->name('.create');
                            Route::post('store/{id}', 'CategoriesController@ItemformStore')->name('.store');
                            Route::get('/edit/{id}','CategoriesController@ItemformEdit')->name('.edit');
                            Route::post('update/{id}','CategoriesController@ItemformUpdate')->name('.update');
                        });
                    });

                });
            });
        });
    });
});
//front-end routes
Route::group(['prefix' => 'advertisement', 'namespace' => 'Modules\Advertisement\Http\Controllers','middleware' => 'web'], function()
{
    Route::get('/sub-category/{id}','AdvertisementController@getSubCategory');
    Route::get('/data-category/{id}','AdvertisementController@getDataCategory');
    Route::get('/data-cities/{id}','AdvertisementController@getCities');
    Route::get('/data-states','AdvertisementController@getStates');
    Route::get('/city','AdvertisementController@getCity');

    Route::get('/search','AdvertisementController@search');
    Route::get('/single','AdvertisementController@single');
    Route::post('/show','AdvertisementController@show');
    Route::get('/list','AdvertisementController@CategoryAdv');
    Route::get('/related','AdvertisementController@related');
    Route::get('/max-price','AdvertisementController@maxPrice');
    Route::group([ 'prefix' => 'category'], function()
    {
        Route::post('/','CategoriesController@category');
        Route::get('/list','CategoriesController@categoryList');
        Route::post('/advertisement','CategoriesController@categoryAdv');
    });
});

Route::middleware(['auth:api'])->group(function () {
        Route::group(['prefix' => 'advertisement', 'namespace' => 'Modules\Advertisement\Http\Controllers'], function(){

        Route::get('/liked','AdvertisementController@getLikedAdvertisement');
        Route::post('/update','AdvertisementController@updateAdv');
        Route::get('/user-advertisement','AdvertisementController@userAdvertisement');
        Route::post('/create','AdvertisementController@create');
        Route::post('/delete','AdvertisementController@delete');
        Route::post('/delete-attachment','AdvertisementController@advDeleteAttachment');
        Route::post('/like','AdvertisementController@like');
        Route::get('/liked-list','AdvertisementController@likedList');

        Route::post('/report/delete','ReportController@delete');
        Route::post('/report/store','ReportController@store');
        Route::post('/report/update','ReportController@update');

        Route::post('/offer/delete','OfferController@delete');
        Route::post('/offer/store','OfferController@store');
        Route::post('/offer/update','OfferController@update');
    });
    Route::group(['prefix' => 'comment', 'namespace' => 'Modules\Advertisement\Http\Controllers'], function()
    {
        Route::post('/','AdvertisementController@comment');
        Route::post('/list','AdvertisementController@commentList');
        Route::post('/delete','AdvertisementController@deleteComment');
    });

    Route::group([ 'prefix' => 'filters','namespace' => 'Modules\Advertisement\Http\Controllers'], function()
    {
        Route::post('/store','FilterController@store');
        Route::get('/show','FilterController@show');
        Route::post('/update','FilterController@update');
        Route::post('/destroy','FilterController@destroy');
    }
    );
});
