<?php

namespace Modules\Advertisement\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Modules\Advertisement\Entities\Advertisement;
use Modules\Advertisement\Entities\Experience;
use Modules\Advertisement\Entities\Offer;
use Yajra\DataTables\Html\Builder;
use Nwidart\Modules\Facades\Module;
use Modules\Core\Http\Controllers\BaseController;
use Yajra\DataTables\DataTables;

class OfferController extends BaseController
{
    protected $htmlBuilder;
    public function __construct(Builder $htmlBuilder)
    {
        $this->htmlBuilder = $htmlBuilder;
        $this->htmlBuilder->parameters([
            'paging' => true,
            'searching' => true,
            'info' => false,
            'searchDelay' => 350,
            'language' => [
                'url' => Module::asset('core:datatable.json')
            ],
        ]);
        Parent::__construct();
    }
    public function index(Request $request)
    {
        if ($request->ajax()) {
            return DataTables::of(Advertisement::find($request->id)->offers()->select(['offers.id',
                DB::raw('concat(users.fname ," ",users.lname) as users_fullname ')
                ,'offer','offers.created_at','offers.updated_at'])->join('users', 'offers.user_id', '=', 'users.id'))
                ->addColumn('operation', function($exp) {
                    return parent::redirectAction('delete/'.$exp->id,'حذف','danger');
                })
                ->rawColumns(['operation'])
                ->make(true);
        }
        $object = 'پیشنهادات';
        $html = $this->htmlBuilder
            ->addColumn(['data' =>'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' => 'users_fullname', 'name' => 'users.fname', 'title' => 'نام کاربر'])
            ->addColumn(['data' => 'users_fullname', 'name' => 'users.lname', 'title' => 'نام کاربر','class'=>'d-none'])
            ->addColumn(['data' => 'offer', 'name' => 'offer', 'title' => 'پیشنهاد'])
            ->addColumn(['data' => 'created_at', 'name' => 'created_at', 'title' => 'ثبت'])
            ->addColumn(['data' => 'updated_at', 'name' => 'updated_at', 'title' => 'ویرایش'])
            ->addColumn(['data' => 'operation', 'name' => 'operation', 'title' => 'عملیات']);
        return view('core::shared.datatable', compact(['html','object']));
    }

    /**
     * Remove the specified resource from storage.
     * @param Request $request
     * @return Response
     */
    public function destroy(Request $request)
    {
        $pid=Offer::find(($request->id))->adv_id;
        Offer::find($request->id)->delete();
        return redirect('admin/advertisement/list/offer/'.$pid);
    }
    /**
     * Remove the specified resource from storage.
     * @param Request $request
     * @return Response
     */
    public function delete(Request $request)
    {
        Offer::find($request->id)->delete();
        return response()->json([
            'data'  => true,
            'message'=>'ok',
            'status' => 200
        ]);
    }
    /**
     * Store a newly created resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function store(Request $request)
    {
        $exp=Offer::create([
            'adv_id'  => $request->adv_id,
            'user_id'=>Auth::user()->id,
            'offer' => $request->offer,
        ]);
        $data=Offer::where('id',$exp->id)->with('user','advertisement')->first();

        return response()->json([
            'data'  => $data,
            'message'=>'ok',
            'status' => 200
        ]);
    }
    /**
     * Update the specified resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function update(Request $request)
    {
        Offer::where('id',$request->id)->update($request->all());
        $data=Offer::where('id',$request->id)->with('user','advertisement')->first();
        return response()->json([
            'data'  => $data,
            'message'=>'ok',
            'status' => 200
        ]);
    }
}
