<?php

namespace Modules\Advertisement\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Modules\Advertisement\Entities\Category;
use Modules\Advertisement\Entities\CategoryItem;
use Modules\Blog\Http\Requests\DeleteCategory;
use Modules\Blog\Http\Requests\EditCategory;
use Modules\Core\Http\Controllers\BaseController;
use Nwidart\Modules\Facades\Module;
use Yajra\DataTables\Html\Builder;
use Yajra\DataTables\DataTables;

class CategoriesController extends BaseController
{
    protected $htmlBuilder;
    public function __construct(Builder $htmlBuilder)
    {
        $this->htmlBuilder = $htmlBuilder;
        $this->htmlBuilder->parameters([
            'paging' => true,
            'searching' => true,
            'info' => false,
            'searchDelay' => 350,
            'language' => [
                'url' => Module::asset('core:datatable.json')
            ],
        ]);
        Parent::__construct();
    }
    public function index(Request $request)
    {
        if ($request->ajax()) {
            return DataTables::of(Category::where('parent_id' , null)->select(['id','title','parent_id','time','price','limit','upload','created_at','updated_at']))
                ->addColumn('operation', function($category) {
                    return parent::redirectAction('list/delete?id='.$category->id,'حذف','danger mr-1')
                        .parent::redirectAction('list/edit?id='.$category->id,'ویرایش','warning mr-1')
                        .parent::redirectAction('list/items/'.$category->id,'آیتم ها','info mr-1');
                })
                ->rawColumns(['operation'])
                ->make(true);
        }
        $object = 'دسته بندی ';
        $html = $this->htmlBuilder
            ->addColumn(['data' =>'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' => 'title', 'name' => 'title', 'title' => 'عنوان'])
            ->addColumn(['data' => 'time', 'name' => 'time', 'title' => 'زمان'])
            ->addColumn(['data' => 'price', 'name' => 'price', 'title' => 'قیمت'])
            ->addColumn(['data' => 'limit', 'name' => 'limit', 'title' => 'محدودیت تعداد'])
            ->addColumn(['data' => 'upload', 'name' => 'upload', 'title' => 'محدودیت حجم'])
            ->addColumn(['data' => 'created_at', 'name' => 'created_at', 'title' => 'ثبت'])
            ->addColumn(['data' => 'updated_at', 'name' => 'updated_at', 'title' => 'ویرایش'])
            ->addColumn(['data' => 'operation', 'name' => 'operation', 'title' => 'عملیات']);

        return view('core::shared.datatable', compact(['html','object']));
    }
    /**
     * Show the form for creating a new resource.
     * @return Response
     */
    public function add()
    {
        $data['model'] = new Category();
        $data['route_action'] = 'advertisement.category.list.store';
        return view('core::shared.add',$data);
    }
    /**
     * Store a newly created resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function store(Request $request)
    {
        $category=Category::create([
            'title' => $request->title,
            'time' =>$request->time,
            'price' =>$request->price,
            'limit' =>$request->limit,
            'upload' =>$request->upload,
        ]);

        //toDo form
        Parent::attachmentProcess($request,$category);

        return redirect()->route('admin.advertisement.category.list');
    }
    /**
     * Show the specified resource.
     * @return Response
     */
    public function show()
    {
        $list=Category::where('parent_id' , null)->orderBy('id','desc')->get();
        return response()->json([
            'data' =>$list,
            'message'=>'ok',
            'status' => 200
        ]);
    }
    /**
     * Show the form for editing a new resource.
     * @param  Request $request
     * @return Response
     */
    public function edit(Request $request)
    {
        $data['route_action'] = 'advertisement.category.list.update';
        $data['data']=Category::find($request->id);
        return view('core::shared.edit', $data);
    }
    /**
     * Update the specified resource in storage.
     * @param  EditCategory $request
     * @return Response
     */
    public function update(EditCategory $request)
    {
        $cat = Category::find(($request->id))->update($request->all());
        $data=Category::find(($request->id));
        Parent::attachmentProcess($request,$data);
        return redirect()->route('admin.advertisement.category.list');
    }
    /**
     * Remove the specified resource from storage.
     * @param  DeleteCategory $request
     * @return Response
     */
    public function destroy(DeleteCategory $request)
    {
        Category::find(($request->id))->delete();
        return redirect('admin/advertisement/category/list');
    }

    public function items(Request $request)
    {
        if ($request->ajax()) {
            return DataTables::of(Category::where('parent_id',$request->id)->select(['id','title','parent_id','time','price','limit','upload','created_at','updated_at']))
                ->addColumn('operation', function($category) {
                    return parent::redirectAction('delete/'.$category->id,'حذف','danger mr-1')
                        .parent::redirectAction('edit/'.$category->id,'ویرایش','warning mr-1')
                        .parent::redirectAction('items/'.$category->id,'آیتم ها','info mr-1')
                        .parent::redirectAction('form/'.$category->id,'فرم','primary mr-1');
                })
                ->rawColumns(['operation'])
                ->make(true);
        }
        $object = 'دسته بندی ';
        $html = $this->htmlBuilder
            ->addColumn(['data' =>'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' => 'title', 'name' => 'title', 'title' => 'عنوان'])
            ->addColumn(['data' => 'time', 'name' => 'time', 'title' => 'زمان'])
            ->addColumn(['data' => 'price', 'name' => 'price', 'title' => 'قیمت'])
            ->addColumn(['data' => 'limit', 'name' => 'limit', 'title' => 'محدودیت تعداد'])
            ->addColumn(['data' => 'upload', 'name' => 'upload', 'title' => 'محدودیت حجم'])
            ->addColumn(['data' => 'created_at', 'name' => 'created_at', 'title' => 'ثبت'])
            ->addColumn(['data' => 'updated_at', 'name' => 'updated_at', 'title' => 'ویرایش'])
            ->addColumn(['data' => 'operation', 'name' => 'operation', 'title' => 'عملیات']);

        return view('core::shared.datatable', compact(['html','object']));
    }
    /**
     * Show the form for creating a new resource.
     * @return Response
     */
    public function itemCreate($id)
    {
        $data['model'] = new Category();
        $data['route_action'] = 'advertisement.category.list.items.store';
        $data['params'] = ['id'=>$id];
        $data['id']=$id;
        return view('core::shared.add',$data);
    }
    /**
     * Store a newly created resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function itemStore(Request $request)
    {
        $category=Category::create([
            'title' => $request->title,
            'time' =>$request->time,
            'price' =>$request->price,
            'limit' =>$request->limit,
            'upload' =>$request->upload,
            'parent_id' =>$request->id,
        ]);
        Parent::attachmentProcess($request,$category);
        return redirect()->route('admin.advertisement.category.list.items' , ['id' => $request->id]);

    }
    /**
     * Show the form for editing a new resource.
     * @param  Request $request
     * @return Response
     */
    public function itemEdit(Request $request)
    {
        $data['route_action'] = 'advertisement.category.list.items.update';
        $data['data']=Category::find($request->id);
        return view('core::shared.edit', $data);
    }
    /**
     * Update the specified resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function itemUpdate(Request $request)
    {
        $cat = Category::find(($request->id))->update($request->all());
        $data=Category::find(($request->id));
        Parent::attachmentProcess($request,$data);
        return redirect()->route('admin.advertisement.category.list.items' , ['id' => $data->parent_id]);
    }
    /**
     * Remove the specified resource from storage.
     * @param  Request $request
     * @return Response
     */
    public function itemDestroy(Request $request)
    {
        $pid=Category::find(($request->id))->parent_id;
        Category::find(($request->id))->delete();
        return redirect('admin/advertisement/category/list/items/'.$pid);
    }
    public function itemForm(Request $request)
    {
        if ($request->ajax()) {
            return DataTables::of(CategoryItem::where('category_id',$request->id)->select(['id','category_id','title','created_at','updated_at']))
                ->addColumn('operation', function($category) {
                    return parent::redirectAction('delete/'.$category->id,'حذف','danger mr-1')
                        .parent::redirectAction('edit/'.$category->id,'مشاهده','warning mr-1');
                })
                ->editColumn('category_id', function($category) {
                    return Category::find($category->category_id)->title;
                })
                ->rawColumns(['operation'])
                ->make(true);
        }
        $object = 'فرم';
        $html = $this->htmlBuilder
            ->addColumn(['data' =>'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' => 'title', 'name' => 'title', 'title' => 'عنوان'])
            ->addColumn(['data' => 'category_id', 'name' => 'category_id', 'title' => 'دسته بندی'])
            ->addColumn(['data' => 'created_at', 'name' => 'created_at', 'title' => 'ثبت'])
            ->addColumn(['data' => 'updated_at', 'name' => 'updated_at', 'title' => 'ویرایش'])
            ->addColumn(['data' => 'operation', 'name' => 'operation', 'title' => 'عملیات']);

        return view('core::shared.datatable', compact(['html','object']));
    }

    public function formDestroy(Request $request)
    {
        $pid=CategoryItem::find(($request->id))->category_id;
        CategoryItem::find(($request->id))->delete();
        return redirect('admin/advertisement/category/list/items/form/'.$pid);
    }
    public function formCreate($id)
    {
        $data['route_action'] = 'advertisement.category.list.items.form.store';
        $data['params'] = ['id'=>$id];
        $data['id']=$id;
        return view('advertisement::category.form',$data);
    }
    public function formStore(Request $request)
    {
        if(isset ($request->optionsTitle)){
            $request['data'] = json_encode($request->optionsTitle);
            $category=CategoryItem::create($request->all());
        }else{
            $category=CategoryItem::create($request->all());
        }
        return redirect()->route('admin.advertisement.category.list.items.form' , ['id' => $request->id]);

    }
    public function formEdit(Request $request)
    {
        $data['route_action'] = 'advertisement.category.list.items.form.update';
        $data['data']=CategoryItem::find($request->id);
        $data['params'] = ['id'=>$request->id];
        $data['id']=$request->id;
        return view('advertisement::category.edit_form', $data);
    }
    public function formUpdate(Request $request)
    {
        $category_id=CategoryItem::where('id',$request->id)->first()->category_id;
        if(isset ($request->optionsTitle)){
            $request['data'] = json_encode($request->optionsTitle);
            $category=CategoryItem::where('id',$request->id)->update([
                'title'=>$request->title,
                'required'=>$request->required,
                'display'=>$request->display,
                'placeholder'=>$request->placeholder,
                'guide_title'=>$request->guide_title,
                'guide_description'=>$request->guide_description,
                'description'=>$request->description,
                'value'=>$request->value,
                'data'=>$request->data,
                'position'=>$request->position,
                'col'=>$request->col,
                'important'=>$request->important,
                'technical'=>$request->technical
            ]);
        }else{
            $category=CategoryItem::where('id',$request->id)->update([
                'title'=>$request->title,
                'required'=>$request->required,
                'display'=>$request->display,
                'placeholder'=>$request->placeholder,
                'guide_title'=>$request->guide_title,
                'guide_description'=>$request->guide_description,
                'description'=>$request->description,
                'value'=>$request->value,
                'data'=>$request->data,
                'position'=>$request->position,
                'col'=>$request->col,
                 'important'=>$request->important,
                'technical'=>$request->technical
            ]);
        }
        return redirect()->route('admin.advertisement.category.list.items.form' , ['id' => $category_id]);
    }

    public function ItemformDestroy(Request $request)
    {
        $pid=CategoryItem::find(($request->id))->category_id;
        CategoryItem::find(($request->id))->delete();
        return redirect('admin/advertisement/category/list/items/form/'.$pid);
    }
    public function ItemformCreate($id)
    {
        $data['route_action'] = 'advertisement.category.list.items.items.form.store';
        $data['params'] = ['id'=>$id];
        $data['id']=$id;
        return view('advertisement::category.form',$data);
    }
    public function ItemformStore(Request $request)
    {
        if(isset ($request->optionsTitle)){
            $request['data'] = json_encode($request->optionsTitle);
            $category=CategoryItem::create($request->all());
        }else{
            $category=CategoryItem::create($request->all());
        }
        return redirect()->route('admin.advertisement.category.list.items.items.form' , ['id' => $request->id]);

    }
    public function ItemformEdit(Request $request)
    {
        $data['route_action'] = 'advertisement.category.list.items.items.form.update';
        $data['data']=CategoryItem::find($request->id);
        $data['params'] = ['id'=>$request->id];
        $data['id']=$request->id;
        return view('advertisement::category.edit_form', $data);
    }
    public function ItemformUpdate(Request $request)
    {
        $category_id=CategoryItem::where('id',$request->id)->first()->category_id;
        if(isset ($request->optionsTitle)){
            $request['data'] = json_encode($request->optionsTitle);
            $category=CategoryItem::where('id',$request->id)->update([
                'title'=>$request->title,
                'required'=>$request->required,
                'display'=>$request->display,
                'placeholder'=>$request->placeholder,
                'guide_title'=>$request->guide_title,
                'guide_description'=>$request->guide_description,
                'description'=>$request->description,
                'value'=>$request->value,
                'data'=>$request->data,
                'position'=>$request->position,
                'col'=>$request->col,
                'important'=>$request->important,
                'technical'=>$request->technical
            ]);
        }else{
            $category=CategoryItem::where('id',$request->id)->update([
                'title'=>$request->title,
                'required'=>$request->required,
                'display'=>$request->display,
                'placeholder'=>$request->placeholder,
                'guide_title'=>$request->guide_title,
                'guide_description'=>$request->guide_description,
                'description'=>$request->description,
                'value'=>$request->value,
                'data'=>$request->data,
                'position'=>$request->position,
                'col'=>$request->col,
                'important'=>$request->important,
                'technical'=>$request->technical
            ]);
        }
        return redirect()->route('admin.advertisement.category.list.items.items.form' , ['id' => $category_id]);
    }
///api
    public function category(Request $request)
    {
        $list=Category::find($request->id)->subs()->with('advertisement')->get();
        return response()->json([
            'data'  => $list,
            'message'=>'ok',
            'status' => 200
        ]);
    }
    public function categoryList()
    {
        $list=Category::where('parent_id' , null)->get();
        return response()->json([
            'data'  => $list,
            'message'=>'ok',
            'status' => 200
        ]);
    }
    public function categoryAdv(Request $request)
    {
        $list=Category::where('id',$request->id)->with('advertisement')->get();
        return response()->json([
            'data'  => $list,
            'message'=>'ok',
            'status' => 200
        ]);
    }


    public function Itemitems(Request $request)
    {
        if ($request->ajax()) {
            return DataTables::of(Category::where('parent_id',$request->id)->select(['id','title','parent_id','time','price','limit','upload','created_at','updated_at']))
                ->addColumn('operation', function($category) {
                    return parent::redirectAction('delete/'.$category->id,'حذف','danger mr-1')
                        .parent::redirectAction('edit/'.$category->id,'ویرایش','warning mr-1')
//                        .parent::redirectAction('items/'.$category->id,'آیتم ها','info mr-1');
                        .parent::redirectAction('form/'.$category->id,'فرم','info mr-1');
                })
                ->rawColumns(['operation'])
                ->make(true);
        }
        $object = 'دسته بندی ';
        $html = $this->htmlBuilder
            ->addColumn(['data' =>'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' => 'title', 'name' => 'title', 'title' => 'عنوان'])
            ->addColumn(['data' => 'time', 'name' => 'time', 'title' => 'زمان'])
            ->addColumn(['data' => 'price', 'name' => 'price', 'title' => 'قیمت'])
            ->addColumn(['data' => 'limit', 'name' => 'limit', 'title' => 'محدودیت تعداد'])
            ->addColumn(['data' => 'upload', 'name' => 'upload', 'title' => 'محدودیت حجم'])
            ->addColumn(['data' => 'created_at', 'name' => 'created_at', 'title' => 'ثبت'])
            ->addColumn(['data' => 'updated_at', 'name' => 'updated_at', 'title' => 'ویرایش'])
            ->addColumn(['data' => 'operation', 'name' => 'operation', 'title' => 'عملیات']);

        return view('core::shared.datatable', compact(['html','object']));
    }
    public function ItemitemCreate($id)
    {
        $data['model'] = new Category();
        $data['route_action'] = 'advertisement.category.list.items.items.store';
        $data['params'] = ['id'=>$id];
        $data['id']=$id;
        return view('core::shared.add',$data);
    }

    public function ItemitemStore(Request $request)
    {
        $category=Category::create([
            'title' => $request->title,
            'time' =>$request->time,
            'price' =>$request->price,
            'limit' =>$request->limit,
            'upload' =>$request->upload,
            'parent_id' =>$request->id,
        ]);
        Parent::attachmentProcess($request,$category);
        return redirect()->route('admin.advertisement.category.list.items.items' , ['id' => $request->id]);

    }
    /**
     * Show the form for editing a new resource.
     * @param  Request $request
     * @return Response
     */
    public function ItemitemEdit(Request $request)
    {
        $data['route_action'] = 'advertisement.category.list.items.items.update';
        $data['data']=Category::find($request->id);
        return view('core::shared.edit', $data);
    }
    /**
     * Update the specified resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function ItemitemUpdate(Request $request)
    {
        $cat = Category::find(($request->id))->update($request->all());
        $data=Category::find(($request->id));
        Parent::attachmentProcess($request,$data);
        return redirect()->route('admin.advertisement.category.list.items.items' , ['id' => $data->parent_id]);
    }
    /**
     * Remove the specified resource from storage.
     * @param  Request $request
     * @return Response
     */
    public function ItemitemDestroy(Request $request)
    {
        $pid=Category::find(($request->id))->parent_id;
        Category::find(($request->id))->delete();
        return redirect('admin/advertisement/category/list/items/items/'.$pid);
    }

}