<?php

namespace Modules\Advertisement\Entities;

use Elasticquent\ElasticquentTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Core\Entities\User;

class Offer extends Model
{
    use SoftDeletes;
    use ElasticquentTrait;

    protected $fillable = ['adv_id','user_id','offer','created_at','updated_at'];
    protected $appends = ['user'];

    public function getUserAttribute()
    {
        return $this->user()->first();

    }
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    public function advertisement()
    {
        return $this->belongsTo(Advertisement::class, 'adv_id');
    }
}
