<?php

namespace Modules\Advertisement\Entities;

use Elasticquent\ElasticquentTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CategoryItem extends Model
{
    use ElasticquentTrait;

    use SoftDeletes;
    protected $table='category_items';
    protected $fillable = ['category_id','title','type','required','display','placeholder','guide_title','guide_description','description','value','data','position','col','important','technical'];

    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id');
    }
}
