<?php

namespace Modules\Advertisement\Entities;

use Elasticquent\ElasticquentTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;
use Modules\Blog\Entities\Comment;
use Modules\Blog\Entities\Like;
use Modules\Core\Entities\Attachment;
use Modules\Core\Entities\City;
use Modules\Core\Entities\User;
use Modules\Shop\Entities\Shop;

class Advertisement extends Model
{
    use ElasticquentTrait;

    use SoftDeletes;
    protected $fillable = ['user_id','sort','description','shop_id','title','status','priority','price','category_id','expiration_time','type','data','accept','like','hit','offer','city_id','latitude','longitude','created_at','updated_at'];
    protected $appends = ['attachmentsImage','attachmentsVideo','liked','likes','category','shop','user'];

    function getLikedAttribute(){
        if(!Auth::user())
            return false;
        return $this->like()->where('user_id',Auth::user()->id)->get()->isNotEmpty();
    }
    function getLikesAttribute(){
        return $this->like()->count();
    }
    public function getAttachmentsImageAttribute()
    {
        if($this->attachments()){
            return $this->attachments()
                ->whereIn('mime',['png','jpeg','jpg'])
                ->orderBy('id','desc')
                ->get();
        }else{
            return [];
        }
    }
    public function getAttachmentsVideoAttribute()
    {
        if($this->attachments()){
            return $this->attachments()->where('mime','mp4')->orderBy('id','desc')->get();
        }else{
            return [];
        }
    }
    public function getShopAttribute()
    {
        if($this->shop_id!=null){
            if($this->shop()){
                return $this->shop()->first();
            }else{
                return null;
            }
        }else{
            return null;
        }


    }
    public function getUserAttribute()
    {
      return $this->user()->first();
    }
    public function getcategoryAttribute()
    {
            return $this->category()->first();
    }
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    public function shop()
    {
        return $this->belongsTo(Shop::class, 'shop_id');
    }
    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id');
    }
    public function offers()
    {
        return $this->hasMany(Offer::class, 'adv_id');
    }
    public function attachments()
    {
        return $this->morphMany(Attachment::class, 'attachmentable');
    }
    public function experience()
    {
        return $this->morphMany(Experience::class, 'experiencable');
    }
    public function comments()
    {
        return $this->morphMany(Comment::class,'commentable');
    }
    function like()
    {
        return $this->morphMany(Like::class,'likable');
    }
    public function City()
    {
        return $this->belongsTo(City::class,'city_id');
    }
}
