<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCategoryItems extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('category_items', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('category_id');
            $table->string('title');
            $table->string('type');
            $table->tinyInteger('required')->default(0);
            $table->tinyInteger('display')->default(1);
            $table->string('placeholder')->nullable();
            $table->string('guide_title')->nullable();
            $table->string('guide_description')->nullable();
            $table->string('description')->nullable();
            $table->string('value')->nullable();
            $table->json('data')->nullable();
            $table->integer('position')->default(1000);
            $table->integer('col')->default(4);
            $table->tinyInteger('technical')->default(0);
            $table->tinyInteger('important')->default(0);
            $table->softDeletes();
            $table->timestamps();
            $table->foreign('category_id')->references('id')->on('categories')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('');
    }
}
