<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Cache\RetrievesMultipleKeys;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Modules\Core\Entities\Role;
use Modules\Core\Entities\User;
use Modules\Core\Http\Controllers\BaseController;
use Modules\Core\Http\Requests\signin;
use Modules\Core\Http\Requests\signup;
use Modules\Core\Http\Requests\StoreUserRole;
use Modules\Expert\Entities\Expert;
use PhpParser\Node\Stmt\Return_;

class UserController extends BaseController
{
    /**
     * This function used for checking existence users mobile
     *
     * @param Request $request
     *
     * @return Response
     */
    function check(Request $request)
    {

        $check=User::where('mobile',$request->mobile)->first();
        if($check == null){
            return response()->json([
                'data'  => false,
                'message'=>'ok',
                'status' => 200
            ]);
        }else{
            $code= rand(10000,99999);
            // $code= 12345;
            BaseController::sendMessage($code,$request->mobile);
            User::where('mobile',$request->mobile)->update(['activation_code'=>$code]);
            return response()->json([
                'data'  => true,
                'message'=>'ok',
                'status' => 200
            ]);
        }
    }

    function resend(Request $request)
    {
        $check=User::where('mobile',$request->mobile)->first();
        if($check == null){
            return response()->json([
                'data'  => false,
                'message'=>'ok',
                'status' => 200
            ]);
        }else{
            $code= User::where('mobile',$request->mobile)->first()->activation_code;
            BaseController::sendMessage($code,$request->mobile);
            return response()->json([
                'data'  => true,
                'message'=>'ok',
                'status' => 200
            ]);
        }
    }
    /**
     * This function used for create a new user
     * @param signup $request
     * @return Response
     */
    function signUp(signup $request)
    {
        $user = User::create([
            'fname' => $request->fname,
            'lname' => $request->lname,
            'email' => $request->email,
            'mobile' => $request->mobile,
            'tell' => $request->tell,
            'city_id' => $request->city_id
        ]);
        Parent::attachmentProcess($request,$user);

        if(isset($request->type)){
                if($request->type=='expert'){
                    $category = collect($request->category_id);
                    $expert=Expert::create([
                        'inbox' => 5,
                        'request' => 1,
                        'city_id' => $request->city_id,
                        'description' => $request->description,
                        'user_id' => $user->id,

                    ]);
                    Expert::find($expert->id)->category()->sync($category ,['created_at' => Carbon::now()]);
                }
            }
            if($request->ajax())
                return response()->json([
                    'data'  => true,
                    'message'=>'ok',
                    'status' => 200
                ]);
            else{
                Auth::loginUsingId($user->id);
            }
        return redirect('/');
    }
    /**
     * This function used to login user
     * @param signin $request
     * @return \Illuminate\Contracts\Routing\ResponseFactory|string|\Symfony\Component\HttpFoundation\Response
     */
    function signIn(signin $request){
        $check=User::where('mobile',$request->mobile)->first();
        if($check !=null){
            $code=$check->activation_code;
            if($code==$request->code){
                if($request->ajax()){
                    Auth::loginUsingId($check->id);
                    $token = Auth::user()->createToken('access_token')->accessToken;
                    return $token;
                }else{
                    Auth::loginUsingId($check->id,1);
                    return redirect('/panel');
                }
            }else{
                if($request->ajax()) {
                    return \response('wrong_code', 401);
                }else{
                    return redirect()->back();
                }
            }
        }else{
            if($request->ajax()) {
                return \response('not exist', 401);
            }else{
                return redirect()->back();
            }
        }
    }
    /**
     * This function used to logout user
     * @return \Illuminate\Contracts\Routing\ResponseFactory|string|\Symfony\Component\HttpFoundation\Response
     */
    public function logout()
    {
        if (Auth::check()) {
            Auth::user()->AauthAcessToken()->delete();
            Auth::logout();
            return redirect('/');
        }
    }
    public function user(){
        $data = Auth::user()->first();
        return response()->json([
            'data'  => $data,
            'message'=>'ok',
            'status' => 200
        ]);
    }
}