<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Modules\Core\Entities\Attachment;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;
use Modules\Core\Http\Controllers\BaseController;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
    }
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('home');
    }
    public function retrievingFiles(Request $request)
    {
        $uid=$request->uid;
        $file = Attachment::where('uid', $uid)->first();
        $mimetype = Storage::mimeType($file->path);
        if (strpos($mimetype, 'video') !== false){
            $stream = new \App\Http\Streamer\VideoStream(storage_path('app/' . $file->path));
            return response()->stream(function () use ($stream){
                $stream->start();
            });
        }
        $img = Image::make(storage_path('app/' . $file->path));
        $height = $img->height();
        $width = $img->width();
        if($height>$width){
            $img->resize(null, $request->height , function ($constraint) {
                $constraint->aspectRatio();
            });
        }else{
            $img->resize($request->width , null, function ($constraint) {
                $constraint->aspectRatio();
            });
        }
        $img->fit($request->width, $request->height, function ($constraint) {
            $constraint->upsize();
        });
        return $img->response('png');
    }
}
