<?php

namespace Modules\Team\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Modules\Core\Http\Controllers\BaseController;
use Modules\Team\Entities\Team;
use Nwidart\Modules\Facades\Module;
use Yajra\DataTables\DataTables;
use Yajra\DataTables\Html\Builder;

class TeamController extends BaseController
{
    protected $htmlBuilder;
    public function __construct(Builder $htmlBuilder)
    {
        $this->htmlBuilder = $htmlBuilder;
        $this->htmlBuilder->parameters([
            'paging' => true,
            'searching' => true,
            'info' => false,
            'searchDelay' => 350,
            'language' => [
                'url' => Module::asset('core:datatable.json')
            ],
        ]);
        Parent::__construct();
    }
    /**
     * Display a listing of the resource.
     * @param Request $request
     * @return Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            return DataTables::of(Team::select(['id','name','education','description', 'created_at', 'updated_at']))
                ->addColumn('operation', function($team) {
                    return parent::redirectAction('list/delete?id='.$team->id,'حذف','danger mr-1')
                        .parent::redirectAction('list/edit?id='.$team->id,'ویرایش','warning mr-1');
                })
                ->rawColumns(['operation','display'])
                ->make(true);
        }
        $object = 'تیم ما';
        $html = $this->htmlBuilder
            ->addColumn(['data' =>'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' =>'name', 'name' => 'name', 'title' => 'نام'])
            ->addColumn(['data' => 'education', 'name' => 'education', 'title' => 'تحصیلات'])
            ->addColumn(['data' => 'description', 'name' => 'description', 'title' => 'توضیحات'])
            ->addColumn(['data' => 'created_at', 'name' => 'created_at', 'title' => 'ثبت'])
            ->addColumn(['data' => 'updated_at', 'name' => 'updated_at', 'title' => 'ویرایش'])
            ->addColumn(['data' => 'operation', 'name' => 'operation', 'title' => 'عملیات']);
        return view('core::shared.datatable', compact(['html','object']));
    }
    /**
     * Show the form for creating a new resource.
     * @return Response
     */
    public function create()
    {
        $data['model'] = new Team();
        $data['route_action'] = 'team.list.store';
        return view('core::shared.add',$data);
    }
    /**
     * Store a newly created resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function store(Request $request)
    {
        $team=Team::create([
            'name' => $request->name,
            'education' => $request->education,
            'description' =>$request->description,
        ]);
        Parent::attachmentProcess($request,$team);
        return redirect()->route('admin.team.list');
    }
    /**
     * Show the specified resource.
     * @return Response
     */
    public function show()
    {
        $data=Team::all();
        return response()->json([
            'data'  => $data,
            'message'=>'ok',
            'status' => 200
        ]);
    }
    /**
     * Show the form for editing the specified resource.
     * @param Request $request
     * @return Response
     */
    public function edit(Request $request)
    {
        $data['route_action'] = 'team.list.update';
        $data['data']=Team::find($request->id);
        return view('core::shared.edit', $data);
    }
    /**
     * Update the specified resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function update(Request $request)
    {
        Team::find(($request->id))->update($request->all());
        $data=Team::find($request->id);
        Parent::attachmentProcess($request,$data);
        return redirect()->route('admin.team.list');
    }
    /**
     * Remove the specified resource from storage.
     * @param Request $request
     * @return Response
     */
    public function destroy(Request $request)
    {
        Team::find($request->id)->delete();
        return redirect('admin/team/list');
    }
}
