<?php

namespace Modules\Team\Entities;

use Elasticquent\ElasticquentTrait;
use Illuminate\Database\Eloquent\Model;

class SocialNetwork extends Model
{
    use ElasticquentTrait;

    protected $fillable = ['telegram','google','twitter','instagram','facebook'];

    protected $table='social_networks';

    public $adminFields=[
        'telegram'=>[
            'type'=>'string',
            'fa_name'=>'telegram',
            'col'=>6,
            'required'=>false,
            'data'=>[]
        ],
        'google'=>[
            'type'=>'string',
            'fa_name'=>'google+',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'twitter'=>[
            'type'=>'string',
            'fa_name'=>'twitter',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'instagram'=>[
            'type'=>'string',
            'fa_name'=>'instagram',
            'col'=>6,
            'required'=>false,
            'data'=>[]
        ],        
        'facebook'=>[
            'type'=>'string',
            'fa_name'=>'facebook',
            'col'=>6,
            'required'=>false,
            'data'=>[]
        ],

    ];

}
