<?php
Route::group(['middleware' => ['web','auth','acl'], 'prefix' => 'admin','as' => 'admin'], function()
{
    Route::group(['middleware' => 'web', 'prefix' => 'slider', 'namespace' => 'Modules\Slider\Http\Controllers' , 'as'=>'.slider'], function()
    {
        Route::group(['middleware' => 'web', 'prefix' => 'list','as' => '.list' ], function()
        {
            Route::get('/delete','SliderController@destroy');
            Route::get('/','SliderController@index');
            Route::get('/create','SliderController@add')->name('.create');
            Route::post('store', 'SliderController@store')->name('.store');
            Route::get('/edit','SliderController@edit')->name('.edit');
            Route::post('update/{id}', 'SliderController@update')->name('.update');
        });
        Route::group(['middleware' => 'web', 'prefix' => 'item' , 'as'=>'.item'], function()
        {
            Route::get('/edit/{id}','ItemController@edit')->name('.edit');
            Route::post('update/{id}', 'ItemController@update')->name('.update');
            Route::get('/delete/{id}','ItemController@destroy')->name('.delete');
            Route::get('/{id}/create','ItemController@add')->name('.create');
            Route::post('store/{id}', 'ItemController@store')->name('.store');
            Route::get('/{id}', 'ItemController@index');
        });
    });
});

Route::group(['middleware' => 'web', 'prefix' => 'slider', 'namespace' => 'Modules\Slider\Http\Controllers'], function()
{
    Route::get('/', 'SliderController@index');
    Route::get('show', 'SliderController@show')->name('.show');
    Route::get('/show-all', 'SliderController@showAll')->name('.showAll');
});
