<?php

namespace Modules\Slider\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;

use Modules\Core\Http\Controllers\BaseController;
use Modules\Slider\Entities\Slider;
use Nwidart\Modules\Facades\Module;
use Yajra\DataTables\DataTables;
use Yajra\DataTables\Html\Builder;

class SliderController extends BaseController
{
    protected $htmlBuilder;
    public function __construct(Builder $htmlBuilder)
    {
        $this->htmlBuilder = $htmlBuilder;
        $this->htmlBuilder->parameters([
            'paging' => true,
            'searching' => true,
            'info' => false,
            'searchDelay' => 350,
            'language' => [
                'url' => Module::asset('core:datatable.json')
            ],
        ]);
        Parent::__construct();
    }
    /**
     * Display a listing of the resource.
     * @param Request $request
     * @return Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            return DataTables::of(Slider::select(['id','title','description', 'slug','created_at','updated_at']))
                ->addColumn('operation', function($slider) {
                    return parent::redirectAction('item/'.$slider->id,'آیتم ها','badge badge-info mr-1')
                    .parent::redirectAction('list/delete?id='.$slider->id,'حذف','danger mr-1')
                        .parent::redirectAction('list/edit?id='.$slider->id,'ویرایش','warning mr-1');
                })
                ->rawColumns(['operation'])
                ->make(true);
        }
        $object = 'اسلایدر ها';
        $html = $this->htmlBuilder
            ->addColumn(['data' =>'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' => 'title', 'name' => 'title', 'title' => 'عنوان'])
            ->addColumn(['data' => 'description', 'name' => 'description', 'title' => 'توضیحات'])
            ->addColumn(['data' => 'slug', 'name' => 'slug', 'title' => 'slug'])
            ->addColumn(['data' => 'created_at', 'name' => 'created_at', 'title' => 'ثبت'])
            ->addColumn(['data' => 'updated_at', 'name' => 'updated_at', 'title' => 'ویرایش'])
            ->addColumn(['data' => 'operation', 'name' => 'operation', 'title' => 'عملیات']);

        return view('core::shared.datatable', compact(['html','object']));
    }
    /**
     * Show the form for creating a new resource.
     * @return Response
     */
    public function add()
    {
        $data['model'] = new Slider();
        $data['route_action'] = 'slider.list.store';
        return view('core::shared.add',$data);
    }
    /**
     * Store a newly created resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function store(Request $request)
    {
        $slider = Slider::create($request->all());
        return redirect()->route('admin.slider.list');
    }
    /**
     * Show the form for editing the specified resource.
     * @param Request $request
     * @return Response
     */
    public function edit(Request $request)
    {
        $data['route_action'] ='slider.list.update';
        $data['data']=Slider::find($request->id);
        return view('core::shared.edit', $data);
    }
    /**
     * Update the specified resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function update(Request $request)
    {
        Slider::find(($request->id))->update($request->all());
        return redirect()->route('admin.slider.list' );
    }
    /**
     * Remove the specified resource from storage.
     * @param Request $request
     * @return Response
     */
    public function destroy(Request $request)
    {
        Slider::find($request->id)->delete();
        return redirect('admin/slider/list');
    }
    /**
     * Show All resource.
     * @return Response
     */
    public function showAll(){
        $data=Slider::with('subs')->get();
        return response()->json([
            'data' =>$data,
            'message'=>'ok',
            'status' => 200
        ]);
    }
    /**
     * Show the specified resource.
     * @param Request $request
     * @return Response
     */
    public function show(Request $request){
        $data=Slider::where('slug',$request->slug)->with('subs')->get();
        return response()->json([
            'data' =>$data,
            'message'=>'ok',
            'status' => 200
        ]);
    }

}
