<?php

namespace Modules\Slider\Entities;

use Elasticquent\ElasticquentTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Core\Entities\Attachment;
use Modules\Slider\Http\Controllers\ItemController;

class SliderItem extends Model
{
    use ElasticquentTrait;
    use SoftDeletes;
    protected $table='slider_items';
    protected $fillable = ['title','description','display','position','slider_id'];
    protected $appends = ['attachments'];
    public function slider(){
        return $this->belongsTo(Slider::class ,'slider_id');
    }
    function attachments(){
        return $this->morphMany(Attachment::class,'attachmentable');
    }
    public function getAttachmentsAttribute()
    {
        return $this->attachments()->get();
    }

    public $adminFields=[

        'image'=>[
            'type'=>'photo',
            'fa_name'=>'عکس ',
            'col'=>12,
            'required'=>false,
            'data'=>[]
        ],

        'title'=>[
            'type'=>'string',
            'fa_name'=>'عنوان',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'description'=>[
            'type'=>'string',
            'fa_name'=>'توضیحات',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],

        'display'=>[
            'type'=>'select',
            'fa_name'=>'نمایش',
            'col'=>6,
            'required'=>true,
            'data'=>ItemController::class.'@display'
        ],
        'position'=>[
            'type'=>'string',
            'fa_name'=>'موقعیت',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
    ];
}
