@extends('core::layouts.master')
@section('head')


    <link href="{{Module::asset('core:node_modules/nestable/jquery-nestable.css')}}" rel="stylesheet"/>
    <link rel="stylesheet" href="{{Module::asset('core:node_modules/select2/dist/css/select2.min.css')}}"/>
    <link rel="stylesheet"
          href="{{Module::asset('core:node_modules/select2-bootstrap-theme/dist/select2-bootstrap.min.css')}}"/>
    <link rel="stylesheet" href="{{Module::asset('core:node_modules/icheck/skins/all.css')}}"/>
    <link rel="stylesheet"
          href="{{Module::asset('core:node_modules/jquery-tags-input/dist/jquery.tagsinput.min.css')}}">
    <link rel="stylesheet" href="{{Module::asset('core:node_modules/dropify/dist/css/dropify.min.css')}}">
    <link rel="stylesheet" href="{{Module::asset('core:css/persian-datepicker.min.css')}}">

@endsection
@section('content')
    <div class="content-wrapper">
        @include('core::layouts.breadcrumb')

        <div class="row">
            <div class="col-12 grid-margin">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                {{--<h4>افزودن بنر</h4>--}}
                            </div>
                            <div class="col-md-6 text-left"><a href="/admin/shop_request/list" class="btn btn-primary">بازگشت به لیست</a>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mt-3">
                                <strong>نام فروشگاه:</strong><span class="mr-2">{{$data->title}}</span>
                            </div>
                            <div class="col-md-6 mt-3">
                                <strong>تلفن ثابت:</strong><span class="mr-2">{{$data->tell}}</span>
                            </div>
                            <div class="col-md-6 mt-3">
                                <strong>تلفن همراه:</strong><span class="mr-2">{{$data->mobile}}</span>
                            </div>
                            <div class="col-md-6 mt-3">
                                <strong>شهر:</strong><span class="mr-2">{{$data->city->title}}</span>
                            </div>
                            <div class="col-md-6 mt-3">
                                <strong>آدرس:</strong><span class="mr-2">{{$data->address}}</span>
                            </div>
                            @foreach($data['attachments'] as $itm)
                                @if(strpos($itm->filename , 'document') === 0)
                                    <div class="col-md-6 mt-3">
                                        <strong>مدارک:</strong><a class="mr-2" href="/admin/shop/list/attachments/download/{{$itm->id}}">فایل با فرمت {{$itm->mime}}</a>
                                    </div>
                                @endif
                                @if(strpos($itm->filename , 'logo') === 0)
                                    <div class="col-md-6 mt-3">
                                        <strong>لوگو:</strong><img src="/files?uid={{$itm->uid}}&width=200&height=200" class="mr-2" />
                                    </div>
                                @endif
                            @endforeach
                        </div>
                        <div class="row">
                            <div class="col-md-12 mt-3">
                                <div id="googleMap" style="width:100%;height:400px;margin-top:20px"></div>
                            </div>
                        </div>
                        <div class="text-left mt-3">
                            <a href="/admin/shop_request/list/update/{{$data->req_id}}" class="btn btn-success">تایید</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')

    <script src="{{Module::asset('core:node_modules/jquery-bar-rating/dist/jquery.barrating.min.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/raphael/raphael.min.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/jquery-sparkline/jquery.sparkline.min.js')}}"></script>
    <script src="{{Module::asset('core:js/jquery-sortable.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/nestable/jquery.nestable.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/select2/dist/js/select2.min.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/icheck/icheck.min.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/jquery-tags-input/dist/jquery.tagsinput.min.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/dropify/dist/js/dropify.min.js')}}"></script>
    <script src="{{Module::asset('core:js/persian-date.min.js')}}"></script>
    <script src="{{Module::asset('core:js/persian-datepicker.min.js')}}"></script>
    <script>

        (function($) {
            'use strict';
            $('.pic-dropify').dropify(
                {
                    messages: {
                        'default': 'عکس خود را در این قسمت رها کنید',
                        'replace': 'عکس خود را در این قسمت رها کنید',
                        'remove':  'حذف',
                        'error':   'خطا رخ داده است'
                    }
                }
            );
            $('.file-dropify').dropify(
                {
                    messages: {
                        'default': 'فایل خود را در این قسمت رها کنید',
                        'replace': 'فایل خود را در این قسمت رها کنید',
                        'remove':  'حذف',
                        'error':   'خطا رخ داده است'
                    }
                }
            );
        })(jQuery);
        $('.persianDate').persianDatepicker({
            autoClose: true,
            onSelect:function(val){
                $('.persianDate').val(new persianDate(val).toCalendar('gregorian').toLocale('en').format('YYYY-MM-DD'))
            }
        });
        $('.persianDateTime').persianDatepicker({
            autoClose: true,
            onSelect:function(val){
                $('.persianDateTime').val(new persianDate(val).toCalendar('gregorian').toLocale('en').format('YYYY-MM-DD hh:mm:ss'))
            },
            timePicker: {
                enabled: true,
                meridiem: {
                    enabled: true
                }
            }});

    </script>
    <script src="{{Module::asset('core:ckeditor/ckeditor.js')}}"></script>

    <script src="{{Module::asset('core:js/iCheck.js')}}"></script>

    <script>
        function setState(val) {
            $.get('/advertisement/data-cities/'+val,function (res) {
                var city = '<option disabled selected>انتخاب نشده</option>'
                res.forEach(function (e) {
                    city +='<option value='+e.city_id+'>'+e.title+'</option>'
                })
                $('#cities').html(city)
            })
        }

        if($('#xeditor').length){
            CKEDITOR.replace('xeditor');
        }
        $(function () {
            $(".js-example-basic-single").select2({dir: 'rtl', placeholder: "انتخاب نشده"});
            $(".js-example-basic-multiple").select2({dir:'rtl',placeholder: "انتخاب نشده"});
            $('#editModal').on('shown.bs.modal', function (e) {
                $(".js-example-basic-single").select2({dir: 'rtl', placeholder: "انتخاب نشده"});
                $(".js-example-basic-multiple").select2({dir:'rtl',placeholder: "انتخاب نشده"});
            })

            $('#tags').tagsInput({
                'width': '100%',
                'height': '100%',
                'interactive': true,
                'defaultText': 'اضافه کردن',
                'removeWithBackspace': true,
                'minChars': 0,
                'maxChars': 20, // if not provided there is no limit
                'placeholderColor': '#666666'
            });

            $('#tags2').tagsInput({
                'width': '100%',
                'height': '100%',
                'interactive': true,
                'defaultText': 'اضافه کردن',
                'removeWithBackspace': true,
                'minChars': 0,
                'maxChars': 20, // if not provided there is no limit
                'placeholderColor': '#666666'
            });
        });
        $(document).on('keyup','#pSearchInput',function(){
            let input = $('#pSearchInput')
            if(input.val().length){
                $('.perm').hide()
                $('div[data-search*='+input.val()+']').show()
            }else{
                $('.perm').show()
            }
        })
    </script>
    {{--    <script src="{{Module::asset('core:/js/dropify.js')}}"></script>--}}
    <script>
        function myMap() {
            var mapProp= {
                center:new google.maps.LatLng({{$data->latitude}},{{$data->longitude}}),
                zoom:7,
            };
            var map=new google.maps.Map(document.getElementById("googleMap"),mapProp);
            var marker = new google.maps.Marker({
                position: mapProp.center,
                map: map,
                draggable:true,
            });
        }
    </script>
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCsT_7eLUr_uriW0-bkVG60zXmDvf2e8fY&callback=myMap"></script>
@endsection