<?php

namespace Modules\Shop\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Modules\Core\Entities\Attachment;
use Modules\Shop\Entities\Shop;
use Yajra\DataTables\DataTables;
use Yajra\DataTables\Html\Builder;
use Nwidart\Modules\Facades\Module;
use Modules\Core\Http\Controllers\BaseController;

class AttachmentController  extends BaseController
{
    protected $htmlBuilder;
    public function __construct(Builder $htmlBuilder)
    {
        $this->htmlBuilder = $htmlBuilder;
        $this->htmlBuilder->parameters([
            'paging' => true,
            'searching' => true,
            'info' => false,
            'searchDelay' => 350,
            'language' => [
                'url' => Module::asset('core:datatable.json')
            ],
        ]);
        Parent::__construct();
    }

    /**
     * Display a listing of the resource.
     *@param  Request $request
     * @return Response
     */
    public function index(Request $request)
    {
        $shop_id=$request->id;
        if ($request->ajax()) {
            return DataTables::of(Attachment::where('attachmentable_type','Modules\Shop\Entities\Shop')->where('attachmentable_id',$shop_id)->select(['id','uid','filename','created_at','updated_at']))
                ->addColumn('operation', function($attachment) {
                    return parent::redirectAction('download/'.$attachment->id,'دانلود','badge badge-info mr-1')
                    .parent::redirectAction('delete/'.$attachment->id,'حذف','badge badge-danger mr-1');
                })
                ->rawColumns(['operation','email','mobile'])
                ->make(true);
        }
        $object = 'پیوست ها';
        $html = $this->htmlBuilder
            ->addColumn(['data' =>'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' =>'filename', 'name' => 'filename', 'title' => 'فایل'])
            ->addColumn(['data' => 'created_at', 'name' => 'created_at', 'title' => 'ثبت'])
            ->addColumn(['data' => 'updated_at', 'name' => 'updated_at', 'title' => 'ویرایش'])
            ->addColumn(['data' => 'operation', 'name' => 'operation', 'title' => 'عملیات']);
        return view('core::shared.datatable', compact(['html','object']));
    }

    /**
     * Show the form for creating a new resource.
     *@param  Request $request
     * @return Response
     */
    public function create(Request $request)
    {
        $id=$request->id;
        $data['model'] = new Attachment();
        $data['route_action'] = 'shop.list.attachments.store';
        $data['params'] = ['id'=>$id];
        $data['id']=$id;
        return view('core::shared.add',$data);
    }
    /**
     * Store a newly created resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function store(Request $request)
    {
        $shop=Shop::find($request->id);
        Parent::multi_attachments_process($request,$shop);
        return redirect()->route('admin.shop.list.attachments',$request->id);
    }
    /**
     * Show the specified resource.
     * @param  Request $request
     * @return Response
     */
    public function download(Request $request)
    {
        $path= Attachment::find($request->id)->path;
        return response()->download(storage_path('app/'.$path));
    }
    /**
     * Remove the specified resource from storage.
     *@param  Request $request
     * @return Response
     */
    public function destroy(Request $request)
    {
        $pid=Attachment::find(($request->id))->attachmentable_id;
        Attachment::find($request->id)->delete();
        return redirect('admin/shop/list/attachments/'.$pid);
    }
}
