<?php

namespace Modules\News\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Maatwebsite\Excel\Facades\Excel;
use Modules\Core\Http\Controllers\BaseController;
use Modules\News\Entities\News;
use Modules\News\Entities\UsersExport;
use Modules\News\Http\Requests\CraeteNews;
use Nwidart\Modules\Facades\Module;
use Yajra\DataTables\DataTables;
use Yajra\DataTables\Html\Builder;

class NewsController extends BaseController
{
    protected $htmlBuilder;
    public function __construct(Builder $htmlBuilder)
    {
        $this->htmlBuilder = $htmlBuilder;
        $this->htmlBuilder->parameters([
            'paging' => true,
            'searching' => true,
            'info' => false,
            'searchDelay' => 350,
            'language' => [
                'url' => Module::asset('core:datatable.json')
            ],
        ]);
        Parent::__construct();
    }
    public function index(Request $request)
    {
        if ($request->ajax()) {
            return DataTables::of(News::select(['id','email', 'created_at', 'updated_at']))
                ->editColumn('operation', function($q) {
                    return parent::redirectAction('list/delete?id='.$q->id,'حدف','danger mr-1')
                        .parent::redirectAction('list/edit?id='.$q->id,'ویرایش','badge badge-warning mr-1');
                })
                ->rawColumns(['operation'])
                ->make(true);
        }
        $object = 'خبرنامه';
        $html = $this->htmlBuilder
            ->addColumn(['data' =>'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' => 'email', 'name' => 'email', 'title' => 'ایمیل'])
            ->addColumn(['data' => 'created_at', 'name' => 'created_at', 'title' => 'ثبت'])
            ->addColumn(['data' => 'updated_at', 'name' => 'updated_at', 'title' => 'ویرایش'])
            ->addColumn(['data' => 'operation', 'name' => 'operation', 'title' => 'عملیات']);
        return view('core::shared.datatable', compact(['html','object']));
    }
    /**
     * Show the specified resource.
     * @return Response
     */
    public function show()
    {
        $data=News::all();
        return response()->json([
            'data' =>$data,
            'message'=>'ok',
            'status' => 200
        ]);
    }
    /**
     * Remove the specified resource from storage.
     * @param  Request $request
     * @return Response
     */
    public function destroy(Request $request)
    {
        News::find(($request->id))->delete();
        return redirect('admin/news/list');
    }
    /**
     * Show the form for creating a new resource.
     * @return Response
     */
    public function add()
    {
        $data['model'] = new News();
        $data['route_action'] = 'news.list.store';
        return view('core::shared.add',$data);
    }
    /**
     * Store a newly created resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function store(Request $request)
    {
        News::create([
            'email' => $request->email,
        ]);
        return redirect()->route('admin.news.list');
    }
    /**
     * Store a newly created resource in storage.
     * @param  CraeteNews $request
     * @return Response
     */
    public function create(CraeteNews $request)
    {
        $data=News::create([
            'email' => $request->email,
        ]);
        return response()->json([
            'data' =>$data,
            'message'=>'ok',
            'status' => 200
        ]);
    }
    /**
     * Show the form for editing the specified resource.
     * @param Request $request
     * @return Response
     */
    public function edit(Request $request)
    {
        $data['route_action'] ='news.list.update';
        $data['data']=News::find($request->id);
        return view('core::shared.edit', $data);
    }
    /**
     * Update the specified resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function update(Request $request)
    {
        News::find(($request->id))->update($request->all());
        return redirect()->route('admin.news.list' );
    }

    public function excel()
    {
        $data=News::all();
        return Excel::download(new UsersExport() , 'email.xlsx');

    }
    public function exceltestt()
    {
        $data = News::all();
        return Excel::create('laravelcode', function($excel) use ($data) {
            $excel->sheet('mySheet', function($sheet) use ($data)
            {
                $sheet->cell('A1', function($cell) {$cell->setValue('First Name');   });
                $sheet->cell('B1', function($cell) {$cell->setValue('Last Name');   });
                $sheet->cell('C1', function($cell) {$cell->setValue('Email');   });
                if (!empty($data)) {
                    foreach ($data as $key => $value) {
                        $i= $key+2;
                        $sheet->cell('A'.$i, $value['firstname']);
                        $sheet->cell('B'.$i, $value['lastname']);
                        $sheet->cell('C'.$i, $value['email']);
                    }
                }
            });
        })->export('csv');
    }
}

