<?php

namespace Modules\Message\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Modules\Message\Entities\Group;
use Modules\Message\Entities\Message;
use Nwidart\Modules\Collection;

class MessageController extends Controller
{

    public function destroy(Request $request)
    {
        $from=Message::where('id',$request)->first()->from;
        if($from==Auth::user()->id){
            Message::find($request->id)->delete();
            return response()->json([
                'data'  =>true,
                'message'=>'ok',
                'status' => 200
            ]);
        }else{
            return response()->json([
                'data'  =>false,
                'message'=>'unAuthenticated',
                'status' => 400
            ]);
        }
    }
    /**
     * Store a newly created resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function store(Request $request)
    {
        $check=Group::where('first',Auth::user()->id)->where('end',$request->to)->first();
        if($check==null){
            $check2=Group::where('end',Auth::user()->id)->where('first',$request->to)->first();
            if($check2==null){
                $group=Group::create(
                    ['end'=>$request->to,
                    'first' => Auth::user()->id
                    ]);
                $data=Message::create([
                    'from'=>Auth::user()->id,
                    'to'=>$request->to,
                    'text'=>$request->text,
                    'group_id'=>$group->id,
                ]);
            }else{
                $data=Message::create([
                    'from'=>Auth::user()->id,
                    'to'=>$request->to,
                    'text'=>$request->text,
                    'group_id'=>$check2->id,
                ]);
            }
        }else{
            $data=Message::create([
                'from'=>Auth::user()->id,
                'to'=>$request->to,
                'text'=>$request->text,
                'group_id'=>$check->id,
            ]);
        }

        return response()->json([
            'data'  =>$data,
            'message'=>'ok',
            'status' => 200
        ]);
    }
    public function show(Request $request)
    {
        $data1=Message::where('from',Auth::user()->id)->where('to',$request->user_id)->pluck('id');
        $data2=Message::where('to',Auth::user()->id)->where('from',$request->user_id)->pluck('id');
        $merged = $data1->merge($data2);
        Message::where('to',Auth::user()->id)->where('from',$request->user_id)->update(['seen'=>1]);
        $data['message']=Message::whereIn('id',$merged)->orderBy('id','desc')->get();
        $data['userId']=Auth::user()->id;
        return response()->json([
            'data'  =>$data,
            'message'=>'ok',
            'status' => 200
        ]);
    }
    public function list()
    {
        $gp=Group::where('first',Auth::user()->id)->orWhere('end',Auth::user()->id)->pluck('id');
        $data['message']=Message::whereIn('group_id',$gp)->with('from_user','to_user')->orderBy('id','desc')->groupBy('group_id')->get();
        $data['userId']=Auth::user()->id;
        return response()->json([
            'data'  =>$data,
            'message'=>'ok',
            'status' => 200
        ]);
    }
}
