<?php

namespace Modules\Menu\Entities;

use Elasticquent\ElasticquentTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Menu\Http\Controllers\ItemController;

class Item extends Model
{
    use ElasticquentTrait;
    use SoftDeletes;
    protected $fillable = ['title', 'description', 'slug', 'display', 'image', 'link', 'target_blank', 'no_follow', 'position', 'parent_type', 'parent_id'];
    protected $appends = ['subs'];

    public function getSubsAttribute()
    {
        return $this->subs()->get();
    }

    public function parentable()
    {
        return $this->morphTo('parentable', 'parent_type', 'parent_id');
    }

    public function subs()
    {
        return $this->morphMany(Item::class, 'parentable', 'parent_type', 'parent_id');
    }

    public $adminFields = [
        'title' => [
            'type' => 'string',
            'fa_name' => 'عنوان',
            'col' => 6,
            'required' => true,
            'data' => []
        ],
        'description' => [
            'type' => 'string',
            'fa_name' => 'توضیحات',
            'col' => 6,
            'required' => true,
            'data' => []
        ],
        'slug' => [
            'type' => 'string',
            'fa_name' => 'slug',
            'col' => 6,
            'required' => true,
            'data' => []
        ],
        'image' => [
            'type' => 'string',
            'fa_name' => 'تصویر',
            'col' => 6,
            'required' => false,
            'data' => []
        ],
        'link' => [
            'type' => 'string',
            'fa_name' => 'لینک',
            'col' => 6,
            'required' => true,
            'data' => []
        ],
        'display' => [
            'type' => 'select',
            'fa_name' => 'نمایش',
            'col' => 6,
            'required' => true,
            'data' => ItemController::class . '@display'
        ],
        'target_blank' => [
            'type' => 'select',
            'fa_name' => 'باز شدن درصفحه جدید',
            'col' => 6,
            'required' => true,
            'data' => ItemController::class . '@target'
        ],
        'no_follow' => [
            'type' => 'select',
            'fa_name' => 'no follow',
            'col' => 6,
            'required' => true,
            'data' => ItemController::class . '@nofollow'
        ],
        'position' => [
            'type' => 'string',
            'fa_name' => 'موقعیت',
            'col' => 6,
            'required' => true,
            'data' => []
        ],
    ];
}
