<?php

Route::group(['middleware' => ['web','auth','acl'],'as'=>'admin', 'prefix' => 'admin', 'namespace' => 'Modules\Financial\Http\Controllers'], function()
{
    Route::group(['middleware' => 'web', 'prefix' => 'financial' ,'as'=>'.financial'], function() {

        Route::group(['middleware' => 'web', 'prefix' => 'packages','as' => '.packages' ], function()
        {
            Route::get('/','PackageController@index');
            Route::get('/delete/{id}','PackageController@destroy')->name('.delete');
            Route::get('/edit/{id}','PackageController@edit')->name('.edit');
            Route::post('update/{id}', 'PackageController@update')->name('.update');
        });

        Route::group(['middleware' => 'web', 'prefix' => 'invoices', 'as' => '.invoices'], function () {
//            Route::get('delete', 'InvoicesController@destroy');
            Route::get('/paid/{id}', 'InvoicesController@setPaid')->name('.paid');
            Route::post('/pay', 'InvoicesController@pay')->name('.pay');
//            Route::get('/create', 'InvoicesController@create')->name('.create');
//            Route::post('/store', 'InvoicesController@store')->name('.store');
            Route::get('/', 'InvoicesController@index');

            Route::get('edit', 'InvoicesController@edit')->name('.edit');
            Route::post('update/{id}', 'InvoicesController@update')->name('.update');
        });

        Route::group(['middleware' => 'web', 'prefix' => 'transactions', 'as' => '.transactions'], function () {
            Route::get('/', 'InvoiceTransactionsController@index');
//            Route::get('/create', 'InvoiceTransactionsController@create')->name('.create');
//            Route::post('/store', 'InvoiceTransactionsController@store')->name('.store');
//            Route::get('/edit/{id}', 'InvoiceTransactionsController@edit')->name('.edit');
//            Route::post('/update', 'InvoiceTransactionsController@update')->name('.update');
        });

        Route::group(['middleware' => 'web', 'prefix' => 'gateways', 'as' => '.gateways'], function () {
            Route::get('/', 'GatewaysController@index');
//            Route::get('/create', 'GatewaysController@create')->name('.create');
//            Route::post('/store', 'GatewaysController@store')->name('.store');
            Route::get('/edit/{id}', 'GatewaysController@edit')->name('.edit');
            Route::post('/update/{id}', 'GatewaysController@update')->name('.update');
        });

        Route::group(['middleware' => 'web', 'prefix' => 'credits', 'as' => '.credits'], function () {
            Route::get('/', 'CreditsController@index');
            Route::get('/create', 'CreditsController@create')->name('.create');
            Route::post('/store', 'CreditsController@store')->name('.store');
            Route::get('/edit/{id}', 'CreditsController@edit')->name('.edit');
            Route::post('/update', 'CreditsController@update')->name('.update');
        });

        Route::group(['middleware' => 'web', 'prefix' => 'discounts', 'as' => '.discounts'], function () {
            Route::get('/', 'DiscountController@index');
            Route::get('/create', 'DiscountController@create')->name('.create');
            Route::post('/store', 'DiscountController@store')->name('.store');
            Route::get('/edit/{id}', 'DiscountController@edit')->name('.edit');
            Route::post('/update/{id}', 'DiscountController@update')->name('.update');
            Route::get('/delete', 'DiscountController@destroy')->name('.delete');
        });
    });
});

Route::group([ 'prefix' => 'financial', 'namespace' =>'Modules\Financial\Http\Controllers','middleware' => ['auth:api']], function() {
        Route::get('wallet','FinancialController@wallet');
        Route::post('create_invoice','FinancialController@createInvoice');
        Route::get('prices','FinancialController@prices');
        Route::get('invoices','FinancialController@invoices');
        Route::post('/pay', 'InvoicesController@pay')->name('.pay');
    });

Route::group(['namespace' =>'Modules\Financial\Http\Controllers' , 'middleware'=> ['web']], function() {
    Route::get('/pay_invoice','PaymentController@pay');
    Route::get('financial/payment_response/{gateway}','PaymentController@response');
    Route::get('/gateways','FinancialController@gateway');
    Route::get('finished','FinancialController@finished');
});

Route::group(['namespace' =>'Modules\Financial\Http\Controllers' , 'middleware'=> ['auth:api']], function() {
    Route::get('/pay_invoice_mobile', 'PaymentController@pay');
    Route::get('/charge_wallet', 'FinancialController@chargeWallet');
    Route::get('/app_invoices', 'FinancialController@appInvoices');
});
