<?php

namespace Modules\Financial\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Modules\Advertisement\Entities\Advertisement;
use Modules\Advertisement\Http\Controllers\AdvertisementController;
use Modules\Core\Http\Controllers\BaseController;
use Modules\Financial\Entities\Discount;
use Modules\Financial\Entities\Gateway;
use Modules\Financial\Entities\Invoice;
use Modules\Financial\Entities\Package;
use Modules\Financial\Entities\UserCredit;

class FinancialController extends BaseController
{
    public function wallet(){
        $data['credit']=UserCredit::credit(Auth::user());
        $data['charged']=UserCredit::where('user_id',Auth::user()->id)->where('amount','>',0)->sum('amount');
        $data['discharged']=UserCredit::where('user_id',Auth::user()->id)->where('amount','<',0)->sum('amount');
        $data['last_invoice']=Invoice::where('user_id',Auth::user()->id)->orderBy('id','DESC')->first();
        return response()->json([
            'data' =>$data,
            'message'=>'OK',
            'status' => 200
        ]);
    }

    public function invoices(){
        return Invoice::where('user_id',Auth::user()->id)->get();
    }

    public function createInvoice(Request $request){
        if($request->title=='advertisement'){
            $adv_id=$request->adv_id;
            $type=$request->type;
            $price_cat=Advertisement::find($adv_id)->category()->first()->price;
            $off_amount='';
            $off_code='';
            if(isset($request->discountCode)){
                $check=Discount::where('code',$request->discountCode)->first();
                if($check !=null){
                    if($check->expiration_time > Carbon::now() && $check->use > 0 ){
                        $dc=100-$check->action;
                        $price_cat=$price_cat* $dc/100;
                        $off_amount=$check->action;
                        $off_code=$request->discountCode;
                    }
                }
            }
            if($type=='immediate'){
                $price=$price_cat+10000;
            }elseif($type=='immediate-special'){
                $price=$price_cat+10000;

            }elseif($type=='special'){
                $price=$price_cat+20000;
            }else{
                $price=$price_cat;
            }
            $data['data'] = json_decode($request->data);
            $data['user_id'] = Auth::user()->id;
            $data['adv_id'] = $request->adv_id;
            $data['type'] =$request->type;

            $invoice = Invoice::create([
                'user_id'=>Auth::user()->id,
                'amount'=>$price,
                'data'=>json_encode($data),
                'handler'=>AdvertisementController::class.'@paid',
                'paid'=>0,
                'description'=>$type,
                'off_code'=>$off_code,
                'off_amount'=>$off_amount,
            ]);
            Parent::multi_attachments_process($request,$invoice);
            $data['invoice_id']=$invoice->id;
            $invoice->update([
                "data" =>json_encode($data)
            ]);

            return response()->json([
                'data'  => $invoice,
                'message'=>'ok',
                'status' => 200
            ]);
        }
        else{
            $package=Package::where('title',$request->title)->first();
            if(isset($request->discountCode)){
                $check=Discount::where('code',$request->discountCode)->first();
                if($check !=null){
                    if($check->expiration_time >= Carbon::now() && $check->use > 0){
                        $dc=100-$check->action;
                        $price=$package->amount * $dc/100;
                        $off_amount=$check->action;
                        $off_code=$request->discountCode;
                    }else{
                        $price=$package->amount;
                        $message='expired';
                        $off_amount=null;
                        $off_code=null;
                    }
                }else{
                    $price=$package->amount;
                    $message='wrong code';
                    $off_amount=null;
                    $off_code=null;
                }
            }
            else{
                $price= $package->amount;
                $off_amount=null;
                $off_code=null;
            }
            $data['data'] = json_decode($request->data);
            $data['user_id'] = Auth::user()->id;

            $invoice = Invoice::create([
                'user_id'=>Auth::user()->id,
                'amount'=>$price,
                'data'=>json_encode($data),
                'handler'=>$package->handler,
                'paid'=>0,
                'description'=>$package->fa,
                'off_code'=>$off_code,
                'off_amount'=>$off_amount,
            ]);
            Parent::multi_attachments_process($request,$invoice);

            $data['invoice_id']=$invoice->id;
            $invoice->update([
                "data" =>json_encode($data)
            ]);
            return \response()->json(
                $invoice->id,
                '201'
            );
        }
    }

    public function prices(Request $request){
        if($request->title=='advertisement'){
           $adv_id=$request->adv_id;
           $price_cat=Advertisement::find($adv_id)->category()->first()->price;
            if(isset($request->discountCode)){
                $check=Discount::where('code',$request->discountCode)->first();
                if($check !=null){
                    if($check->expiration_time > Carbon::now() && $check->use > 0 ){
                        $dc=100-$check->action;
                        $price_cat=$price_cat* $dc/100;
                    }
                }
            }
               $price['immediate']=$price_cat+10000;
               $price['immediate-special']=$price_cat+10000;
               $price['special']=$price_cat+20000;

            return response()->json([
                'data'  => $price,
                'message'=>'ok',
                'discount'=> '',
                'status' => 200
            ]);

        }
        else{
            $package=Package::where('title',$request->title)->first();
            if(isset($request->discountCode)){
                $check=Discount::where('code',$request->discountCode)->first();
                if($check !=null){
                    if($check->expiration_time > Carbon::now() && $check->use > 0 ){
                        $dc=100-$check->action;
                        $price=$package->amount * $dc/100;
                        $message='ok';
                        $dis=$check->action;
                    }else{
                        $price=$package->amount;
                        $message='expired';
                        $dis='';
                    }
                }else{
                    $price=$package->amount;
                    $message='wrong code';
                    $dis='';
                }
                return response()->json([
                    'data'  => $price,
                    'message'=>$message,
                    'discount'=> $dis,
                    'status' => 200
                ]);
            }
            else{
                $price=$package->amount;
                return response()->json([
                    'data'  => $price,
                    'message'=>'ok',
                    'discount'=> '',
                    'status' => 200
                ]);
            }
        }
    }

    public function pay(Request $request){
        $invoice = Invoice::find($request->invoice);
        if(Auth::user()->id == $invoice->user_id){
            self::payInvoice($request->invoice,$request->gateway);
        }else{
            return redirect('/');
        }
    }

    public function gateway(){
        return Gateway::where('active',1)->get();
    }

    public function chargeWallet(Request $request){
        $invoice = Invoice::create([
            'user_id'=>Auth::user()->id,
            'amount'=>$request->price,
            'data'=>json_encode(['user_id'=>Auth::user()->id,'amount'=>$request->price]),
            'handler'=>CreditsController::class.'@chargeWallet',
            'paid'=>0,
            'description'=>'شارژ کیف پول',
        ]);
        return \response()->json([
            'message'=>'charged',
            'data'=>$invoice,
            'status'=>201
        ]);
    }

    public function finished(){
        return view('front.accept.index');
    }

    public function appInvoices(){
        $data['invoices'] = Invoice::with('transaction.gateway')->get();
        $data['credit']=UserCredit::credit(Auth::user());
        $data['charged']=UserCredit::where('user_id',Auth::user()->id)->where('amount','>',0)->sum('amount');
        $data['discharged']=UserCredit::where('user_id',Auth::user()->id)->where('amount','<',0)->sum('amount');
        return \response()->json([
           'data'=>$data,
           'status'=>200,
           'message'=>'OK'
        ]);
    }

}
