<?php

namespace Modules\Financial\Entities;

use Illuminate\Database\Eloquent\Model;
use Modules\Core\Entities\User;

class UserCredit extends Model
{
    protected $fillable = ['amount','user_id','desc'];

    public function user(){
        return $this->belongsTo(User::class);
    }

    static public function credit($user){
        if(is_object($user)){
            return self::where('user_id',$user->id)->sum('amount');
        }else{
            return self::where('user_id',$user)->sum('amount');
        }
    }

    static public function charge($user,$amount){
        if(is_object($user)){
            self::create([
                'amount'=>$amount,
                'user_id'=>$user->id,
                'desc'=>'شارژ کیف پول'
            ]);
            return true;
        }else{
            self::create([
                'amount'=>$amount,
                'user_id'=>$user,
                'desc'=>'شارژ کیف پول'
            ]);
            return true;
        }
    }
}
