<?php

namespace Modules\Financial\Entities;

use Illuminate\Database\Eloquent\Model;
use Modules\Core\Entities\Attachment;
use Modules\Core\Entities\User;
use Modules\Financial\Entities;

class Invoice extends Model
{
    protected $fillable = ['user_id','amount','data','handler','paid','description','off_amount','off_code','content'];

    public function user(){
        return $this->belongsTo(User::class);
    }

    public function transaction(){
        return $this->hasMany(InvoiceTransaction::class)->where('status',1);
    }
    function attachments(){
        return $this->morphMany(Attachment::class,'attachmentable');
    }

    public $adminFields=[

        'content'=>[
            'type'=>'string',
            'fa_name'=>'توضیحات',
            'col'=>6,
            'required'=>false,
            'data'=>[]
        ],
    ];

}
