@extends('core::layouts.master')
@section('head')


    <link href="{{Module::asset('core:node_modules/nestable/jquery-nestable.css')}}" rel="stylesheet"/>
    <link rel="stylesheet" href="{{Module::asset('core:node_modules/select2/dist/css/select2.min.css')}}"/>
    <link rel="stylesheet"
          href="{{Module::asset('core:node_modules/select2-bootstrap-theme/dist/select2-bootstrap.min.css')}}"/>
    <link rel="stylesheet" href="{{Module::asset('core:node_modules/icheck/skins/all.css')}}"/>
    <link rel="stylesheet"
          href="{{Module::asset('core:node_modules/jquery-tags-input/dist/jquery.tagsinput.min.css')}}">
    <link rel="stylesheet" href="{{Module::asset('core:node_modules/dropify/dist/css/dropify.min.css')}}">
    <link rel="stylesheet" href="{{Module::asset('core:css/persian-datepicker.min.css')}}">

@endsection
@section('content')

    <div class="content-wrapper">
        @include('core::layouts.breadcrumb')
        <div class="row">
            <div class="col-12 grid-margin">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                {{--<h4>افزودن بنر</h4>--}}
                            </div>
                            <div class="col-md-6 text-left"><a href="{{($redirectBack)}}" class="btn btn-primary">بازگشت
                                    به لیست</a>
                            </div>
                        </div>
                        <form action="{{route('admin.'.$route_action,$data->id)}}" method="post"
                              enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                @foreach($data->adminFields as $index=>$item)
                                    @switch($item['type'])
                                        @case('photo')
                                        <div class="col-md-{{$item['col']}}">
                                            <div class="form-group pt-3">
                                                <label>@if($item['required'])<span class="ml-1"
                                                                                   style="color: red;vertical-align: sub">*</span>@endif{{$item['fa_name']}}
                                                </label>
                                                <div class="mt-1">
                                                    <input name="{{$index}}" @if($item['required']) required
                                                           @endif type="file" class="dropify"/>
                                                </div>
                                            </div>
                                        </div>
                                        @break
                                        @case('string')
                                        <div class="col-md-{{$item['col']}}">
                                            <div class="form-group pt-3">
                                                <label><span class="ml-1"
                                                             style="color: red;vertical-align: sub">*</span>{{$item['fa_name']}}
                                                </label>
                                                <input @if($item['required']) required @endif type="text"
                                                       name="{{$index}}" value="{{$data->$index}}"
                                                       class="form-control mt-1"
                                                       placeholder="{{$item['fa_name']}}">
                                            </div>
                                        </div>
                                        @break
                                        @case('boolean')


                                        <div class="col-md-{{$item['col']}}">
                                            <div class="form-group pt-3">
                                                <div class="mt-4">
                                                    <label style="vertical-align: middle">{{$item['fa_name']}}</label>
                                                    <label class="switch ml-3 pull-left" style="vertical-align: middle">
                                                        <input name="{{$index}}" value="0" type="hidden">
                                                        <input @if($item['required']) required @endif name="{{$index}}"
                                                               value="1" type="checkbox"
                                                               @if($data->$index) checked @endif>
                                                        <span class="slider round"></span>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        @break

                                        @case('cities')
                                            @if($data->city_id != null && $data->state_id != null )
                                            <div class="col-md-6">
                                                <div class="form-group pt-3">
                                                    <label>انتخاب استان</label>
                                                    <div class="mt-1">
                                                        <select class="js-example-basic-single w-100"
                                                                onchange="setState(this.value)">
                                                            @php
                                                                $city_id=$data->city_id;
                                                                $state_id=\Modules\Core\Entities\City::where('id',$city_id)->first()->state_id;
                                                                    $ids=\Modules\Core\Entities\City::where('state_id',$state_id)->pluck('id');
                                                                    $state_cities=\Modules\Core\Entities\CityTranslation::whereIn('city_id',$ids)->get();
                                                                $state=\Modules\Core\Entities\StateTranslation::all();
                                                            @endphp
                                                            @foreach($state as $item)
                                                                <option value="{{$item->id}}"
                                                                        @if($item->id == $state_id) selected @endif>{{$item->title}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group pt-3">
                                                    <label>انتخاب شهر</label>
                                                    <div class="mt-1">
                                                        <select class="js-example-basic-single w-100" id="cities"
                                                                name="city_id">
                                                            @foreach($state_cities as $item)
                                                                <option value="{{$item->city_id}}"
                                                                        @if($item->city_id == $city_id) selected @endif>{{$item->title}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            @endif
                                        @break
                                        @case('text')
                                        <div class="col-md-{{$item['col']}}">
                                            <div class="form-group pt-3">
                                                <label for="xeditor">{{$item['fa_name']}}</label>
                                                <textarea @if($item['required']) required @endif name="{{$index}}"
                                                          id="xeditor" rows="50"
                                                          cols="80"> {{$data->$index}} </textarea>
                                            </div>
                                        </div>
                                        @break
                                        @case('radio')
                                        @foreach($item['data'] as $tmpIndex=>$name)
                                            <div class="col-sm-3 mt-1">
                                                <div class="icheck-square">
                                                    <input @if($item['required']) required @endif tabindex="7"
                                                           value="{{$tmpIndex}}" type="radio"
                                                           @if($data->$index == $tmpIndex) checked @endif
                                                           id="xradio{{$tmpIndex}}" name="{{$index}}">
                                                    <label for="xradio{{$tmpIndex}}">{{$name}}</label>
                                                </div>
                                            </div>
                                        @endforeach
                                        @break
                                        @case('password')
                                        <div class="col-md-{{$item['col']}}">
                                            <div class="form-group pt-3">
                                                <label><span class="ml-1"
                                                             style="color: red;vertical-align: sub">*</span>{{$item['fa_name']}}
                                                </label>
                                                <input @if($item['required']) required @endif type="password"
                                                       name="{{$index}}" class="form-control mt-1"
                                                       placeholder="{{$item['fa_name']}}">
                                            </div>
                                        </div>
                                        @break
                                        @case('select')
                                        <div class="col-md-{{$item['col']}}">
                                            <div class="form-group pt-3">
                                                <label>{{$item['fa_name']}}</label>
                                                <div class="mt-1">
                                                    <select name="{{$index}}" class="js-example-basic-single w-100">
                                                        @foreach(\Modules\Core\Http\Controllers\BaseController::selectValue($item['data']) as $tmpIndex=>$tmpValue)
                                                            <option value="{{$tmpIndex}}"
                                                                    @if($data->$index == $tmpIndex) selected @endif >{{$tmpValue}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        @break
                                        @case('multipleSelect')
                                        <div class="col-md-{{$item['col']}}">
                                            <div class="form-group pt-3">
                                                @if(isset($param))
                                                    <label>{{$item['fa_name']}}</label>
                                                    <select name="{{$index}}" class="js-example-basic-multiple w-100"
                                                            multiple="multiple">
                                                        @foreach($param as $index=>$param_item)
                                                            <option value="{{$index}}" selected>{{$param_item}}</option>
                                                        @endforeach
                                                        @foreach(\Modules\Core\Http\Controllers\BaseController::selectValue($item['data']) as $tmpIndex=>$tmpValue)
                                                            @if(!isset($param[$tmpIndex]))
                                                                <option value="{{$tmpIndex}}">{{$tmpValue}}</option>
                                                            @endif
                                                        @endforeach
                                                    </select>
                                                @else
                                                    <label>{{$item['fa_name']}}</label>
                                                    <select name="{{$index}}" class="js-example-basic-multiple w-100"
                                                            multiple="multiple">
                                                        @foreach(\Modules\Core\Http\Controllers\BaseController::selectValue($item['data']) as $tmpIndex=>$tmpValue)
                                                            <option value="{{$tmpIndex}}">{{$tmpValue}}</option>
                                                        @endforeach
                                                    </select>
                                                @endif
                                            </div>

                                        </div>
                                        @break
                                        @case('custom')
                                        @include($item['data'])
                                        @break@case('time')
                                        <div class="col-md-{{$item['col']}}">
                                            <div class="form-group pt-3">
                                                <label><span class="ml-1"
                                                             style="color: red;vertical-align: sub">*</span>{{$item['fa_name']}}
                                                </label>
                                                <input @if($item['required']) required @endif type="time"
                                                       name="{{$index}}" class="form-control mt-1"
                                                       placeholder="{{$item['fa_name']}}">
                                            </div>
                                        </div>
                                        @break
                                        @case('date')
                                        <div class="col-md-{{$item['col']}}">
                                            <div class="form-group pt-3">
                                                <label><span class="ml-1"
                                                             style="color: red;vertical-align: sub">*</span>{{$item['fa_name']}}
                                                </label>
                                                <input name="{{$index}}" placeholder="{{$item['fa_name']}}"
                                                       class="form-control mt-1 persianDate"
                                                       @if($item['required']) required @endif />
                                            </div>
                                        </div>
                                        @break
                                        @case('dateTime')
                                        <div class="col-md-{{$item['col']}}">
                                            <div class="form-group pt-3">
                                                <label><span class="ml-1"
                                                             style="color: red;vertical-align: sub">*</span>{{$item['fa_name']}}
                                                </label>
                                                <input name="{{$index}}" placeholder="{{$item['fa_name']}}"
                                                       class="form-control mt-1 persianDateTime"
                                                       @if($item['required']) required @endif />
                                            </div>
                                        </div>
                                        @break
                                        @case('map')
                                        <div class="col-md-12">
                                            <div id="googleMap" style="width:100%;height:400px;margin-top:20px"></div>
                                            <input type="hidden" id="lat" name="latitude"
                                                   value="{{$data['latitude']}}"/>
                                            <input type="hidden" id="lng" name="longitude"
                                                   value="{{$data['longitude']}}"/>
                                        </div>
                                        @break
                                    @endswitch
                                @endforeach
                                <div class="col-md-12">
                                    <div class="form-group pt-5 text-left">
                                        <button type="submit" class="btn btn-success">ثبت</button>
                                        <a href="{{($redirectBack)}}" class="btn btn-danger">انصراف</a>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')

    <script src="{{Module::asset('core:node_modules/jquery-bar-rating/dist/jquery.barrating.min.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/raphael/raphael.min.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/jquery-sparkline/jquery.sparkline.min.js')}}"></script>
    <script src="{{Module::asset('core:js/jquery-sortable.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/nestable/jquery.nestable.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/select2/dist/js/select2.min.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/icheck/icheck.min.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/jquery-tags-input/dist/jquery.tagsinput.min.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/dropify/dist/js/dropify.min.js')}}"></script>
    <script src="{{Module::asset('core:ckeditor/ckeditor.js')}}"></script>

    <script src="{{Module::asset('core:js/persian-date.min.js')}}"></script>
    <script src="{{Module::asset('core:js/persian-datepicker.min.js')}}"></script>
    <script>
        console.log(new Date())
        $('.persianDate').persianDatepicker({
            autoClose: true,
            onSelect: function (val) {
                $('.persianDate').val(new persianDate(val).toCalendar('gregorian').toLocale('en').format('YYYY-MM-DD'))
            }
        });
        $('.persianDateTime').persianDatepicker({
            autoClose: true,
            onSelect: function (val) {
                $('.persianDateTime').val(new persianDate(val).toCalendar('gregorian').toLocale('en').format('YYYY-MM-DD hh:mm:ss'))
            },
            timePicker: {
                enabled: true,
                meridiem: {
                    enabled: true
                }
            }
        });


    </script>
    <script src="{{Module::asset('core:js/iCheck.js')}}"></script>

    <script>

        function setState(val) {
            $.get('/advertisement/data-cities/' + val, function (res) {
                var city = '<option disabled selected>انتخاب نشده</option>'
                res.forEach(function (e) {
                    city += '<option value=' + e.city_id + '>' + e.title + '</option>'
                })
                $('#cities').html(city)
            })
        }

        $(function () {
            $(".js-example-basic-single").select2({dir: 'rtl', placeholder: "انتخاب نشده"});
            $(".js-example-basic-multiple").select2({dir: 'rtl', placeholder: "انتخاب نشده"});
            $('#editModal').on('shown.bs.modal', function (e) {
                $(".js-example-basic-single").select2({dir: 'rtl', placeholder: "انتخاب نشده"});
                $(".js-example-basic-multiple").select2({dir: 'rtl', placeholder: "انتخاب نشده"});
            })

            $('#tags').tagsInput({
                'width': '100%',
                'height': '100%',
                'interactive': true,
                'defaultText': 'اضافه کردن',
                'removeWithBackspace': true,
                'minChars': 0,
                'maxChars': 20, // if not provided there is no limit
                'placeholderColor': '#666666'
            });

            $('#tags2').tagsInput({
                'width': '100%',
                'height': '100%',
                'interactive': true,
                'defaultText': 'اضافه کردن',
                'removeWithBackspace': true,
                'minChars': 0,
                'maxChars': 20, // if not provided there is no limit
                'placeholderColor': '#666666'
            });
            $('.icon-plus').on('click', function () {
                $('.attachments').append('<div class="pt-3"> <input type="file" class="dropify" /></div>')
                $('.dropify').dropify();
            })
        });
        if ($('#xeditor').length) {
            CKEDITOR.replace('xeditor');
        }
    </script>
    <script src="{{Module::asset('core:/js/dropify.js')}}"></script>
    <script>
        function myMap() {
            var mapProp = {
                center: new google.maps.LatLng(@if($data['latitude'] && $data['longitude']){{$data['latitude']}}, {{$data['longitude']}}@else 35.6970118, 51.2097354 @endif),
                    zoom
        :
            7,
        }
            ;
            var map = new google.maps.Map(document.getElementById("googleMap"), mapProp);
            var marker = new google.maps.Marker({
                position: mapProp.center,
                map: map,
                draggable: true,
            });
            map.addListener('click', function (event) {
                placeMarker(map, marker, event.latLng);
            });
            marker.addListener('dragend', function (event) {
                placeMarker(map, marker, event.latLng)
            })
        }

        function placeMarker(map, marker, location) {
            marker.setPosition(location)
            $('#lat').val(location.lat())
            $('#lng').val(location.lng())
        }
    </script>
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCsT_7eLUr_uriW0-bkVG60zXmDvf2e8fY&callback=myMap"></script>
@endsection
