@extends('core::layouts.master')
@section('head')

    <link rel="stylesheet" href="{{Module::asset('core:node_modules/datatables.net-bs4/css/dataTables.bootstrap4.css')}}" />
    <link rel="stylesheet" href="{{Module::asset('core:node_modules/fancybox/jquery.fancybox.min.css')}}" />
    <style>
        .dataTables_paginate{text-align: left}
        .dataTables_paginate span{display: inline-flex;}
        .dataTables_paginate span a{border-right: 0 !important}
        .dataTables_paginate span a:last-child{border-left: 0 !important}
        .dataTables_paginate .ellipsis{padding: 10px;border:1px solid #eee;line-height: 25px}
        .dataTables_paginate a.paginate_button{padding: 10px;border:1px solid #eee;line-height: 25px}
        .dataTables_paginate a.paginate_button.current{background-color: #007bff;color:white;border-color: #007bff}
    </style>
@endsection
@section('content')
    <div class="content-wrapper">
        @include('core::layouts.breadcrumb')
        <!-- Button trigger modal -->
            <!-- Modal -->
            <div class="modal fade" id="modalEdit" tabindex="-1" role="dialog" aria-labelledby="modelTitleId"
                 aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            Body
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                            <button type="button" class="btn btn-primary">Save</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6"><h4 class="card-title">مدیریت {{$object}}</h4></div>
                    @if(Route::has(\Request::route()->getName().'.create')) <div class="col-md-6 text-left"><a href="{{url()->current()}}/create" class="btn btn-primary">+ افزودن </a></div> @endif
                </div>
                <div class="row mt-3">
                    <div class="col-12 mt-3 table-responsive">
                        {!! $html->table(['class' => 'table'], true) !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <!-- Plugin js for this page-->
    <script src="{{Module::asset('core:node_modules/datatables.net/js/jquery.dataTables.js')}}"></script>
    {!! $html->scripts() !!}
    <script>

        $(document).on('show.bs.modal',function(e){
            $('.modal-body').html($(e.relatedTarget).attr('data-html'))
        })
    </script>

    <script>
        function deleteAction(id,e){
            let tr = $(e).closest('tr');
            swal({
                title: 'آیا از حذف این آیتم مطمئن هستید؟',
                text: "بعد از حذف امکان بازگشت اطلاعات وجود ندارد!",
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#fb9678',
                cancelButtonColor: '#00c292',
                confirmButtonText: 'حذف',
                cancelButtonText: 'انصراف'
            }).then((result) => {
                if (result.value) {
                    tr.fadeOut()
                    $.get('{{url()->current()}}/delete?id='+id,function(){
                        $.toast({
                            textAlign : 'right',
                            heading: 'عملیات موفق',
                            text: 'آیتم مورد نظر با موفقیت حذف شد',
                            showHideTransition: 'slide',
                            icon: 'success',
                            loaderBg: '#f96868',
                            position: 'top-right'
                        })
                    })
                }
            })
        }
    </script>

    {{--<script src="{{Module::asset('core:node_modules/jquery-bar-rating/dist/jquery.barrating.min.js')}}"></script>--}}
    {{--<script src="{{Module::asset('core:node_modules/raphael/raphael.min.js')}}"></script>--}}
    {{--<script src="{{Module::asset('core:node_modules/jquery-sparkline/jquery.sparkline.min.js')}}"></script>--}}
    {{--<script src="{{Module::asset('core:node_modules/datatables.net-bs4/js/dataTables.bootstrap4.js')}}"></script>--}}
    {{--<script src="{{Module::asset('core:node_modules/fancybox/jquery.fancybox.min.js')}}"></script>--}}
    {{--<script src="{{Module::asset('core:js/data-table.js')}}"></script>--}}
@endsection
