<?php

namespace Modules\Core\Notifications;

use Illuminate\Notifications\Messages\BroadcastMessage;
use Illuminate\Notifications\Notification;
use Modules\Core\Entities\User;
use NotificationChannels\WebPush\WebPushChannel;
use NotificationChannels\WebPush\WebPushMessage;

class CustomNotification extends Notification
{

    public $user=null;
    public $customNotification=null;

    public function __construct(User $user,\Modules\Core\Entities\CustomNotification $customNotification)
    {
        $this->user=$user;
        $this->customNotification=$customNotification;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */

    public function via($notifiable)
    {
        return [WebPushChannel::class,'database','broadcast'];
    }

    public function toWebPush($notifiable, $notification)
    {
        return (new WebPushMessage)
            ->title($this->customNotification->title)
//            ->icon('/approved-icon.png')
            ->body($this->customNotification->content)
            ->data([
                'title'=>$this->customNotification->title,
                'description'=>$this->customNotification->description,
                'content'=>$this->customNotification->content,
//                'avatar'=>$this->user->attachments()->where('name', 'avatar')->first(),

            ]);
//            ->action('View account', 'view_account');


    }

    public function toBroadcast($notifiable)
    {
        return new BroadcastMessage([

            'title'=>$this->customNotification->title,
            'description'=>$this->customNotification->description,
            'content'=>$this->customNotification->content
        ]);
    }
    public function toDatabase($notifiable)
    {
        return new BroadcastMessage([
            'title'=>$this->customNotification->title,
            'description'=>$this->customNotification->description,
            'content'=>$this->customNotification->content
        ]);
    }
}
