<?php

Route::group(['middleware' => ['web','auth'], 'prefix' => 'admin','as'=>'admin', 'namespace' => 'Modules\Core\Http\Controllers'], function()
{
    Route::get('/', 'CoreController@index');
    Route::group(['prefix' => 'core','as'=>'.core'], function(){
        Route::group(['prefix' => 'permissions','as'=>'.permissions'], function(){
            Route::get('/','PermissionsController@index');
            Route::get('/edit','PermissionsController@showEdit')->name('.edit');
            Route::post('/update/{id}','PermissionsController@edit')->name('.update');
            Route::get('delete', 'PermissionsController@destroy')->name('.delete');
        });
        Route::group(['prefix' => 'roles','as'=>'.roles'], function(){
            Route::get('/','RolesController@index');
            Route::get('/create','RolesController@add')->name('.create');
            Route::post('/store','RolesController@store')->name('.store');
            Route::get('/edit/{id}','RolesController@showEdit')->name('.edit');
            Route::post('/update/{id}','RolesController@edit')->name('.update');
            Route::get('delete', 'RolesController@destroy')->name('.delete');
        });
        Route::group(['prefix' => 'user_role','as'=>'.user_role'], function(){
            Route::get('/','UserRoleController@index');
            Route::get('/edit','UserRoleController@showEdit')->name('.edit');
            Route::get('/create','UserRoleController@create')->name('.create');
            Route::post('/store','UserRoleController@storeuser')->name('.store');
            Route::post('/update/{id}','UserRoleController@edit')->name('.update');
            Route::get('delete/{id}', 'UserRoleController@destroy')->name('.delete');
        });

        Route::group(['prefix' => 'custom','as'=>'.custom'], function(){
            Route::get('/','CustomNotificationController@index');
            Route::get('create','CustomNotificationController@add')->name('.create');
            Route::post('store','CustomNotificationController@store')->name('.store');
        });

        Route::group(['prefix' => 'special_user','as'=>'.special_user'], function(){
            Route::get('/','SpecialUserController@index');
            Route::get('delete/{id}', 'SpecialUserController@destroy')->name('.delete');
            Route::get('/create','SpecialUserController@add')->name('.create');
            Route::post('/store','SpecialUserController@store')->name('.store');
        });
        Route::group(['prefix' => 'update','as'=>'.update'], function(){
            Route::get('/','UpdatesController@index');
            Route::get('delete/{id}', 'UpdatesController@destroy')->name('.delete');
            Route::get('/create','UpdatesController@add')->name('.create');
            Route::post('/store','UpdatesController@store')->name('.store');
        });
    });
});

Route::middleware(['auth:api'])->group(function () {

Route::group(['prefix' => 'core','namespace' => 'Modules\Core\Http\Controllers'], function()
{
    Route::post('update','UserController@update');
    Route::get('edit','UserController@edit');
    Route::get('show','UserController@show');
    Route::get('user','UserController@user');
    Route::get('get-user','UserController@getUser');
    Route::get('/is-special','SpecialUserController@isSpecial');

    Route::group(['prefix' => 'notification'], function(){
        Route::get('/','NotificationController@getNotifications');
        Route::get('/unread-notifications','NotificationController@getUnreadNotifications')->name('.getUnreadNotifications');
        Route::post('/notification_read','NotificationController@notification_read')->name('.notification_read');
        Route::get('/subscription','NotificationController@subscription')->name('.subscription');
        Route::post('/delete-subscription','NotificationController@deleteSubscription')->name('.deleteSubscription');
        Route::get('sub', 'NotificationController@sub')->name('.sub');
    });
});
});

Route::group(['namespace' => 'Modules\Core\Http\Controllers'], function() {

    Route::get('/superadmin_login_page','UserController@superadmin');
    Route::middleware(['auth:api'])->group(function () {
        Route::get('/is_auth', 'UserController@isAuth');
    });
});

Route::group([ 'prefix' => 'core', 'namespace' => 'Modules\Core\Http\Controllers','middleware' => 'web'], function()
{
    Route::get('/state','CityController@state');
    Route::get('/cities/{id}','CityController@getCities');
    Route::get('/updates/show','UpdatesController@show');
});