<?php

namespace Modules\Core\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Modules\Blog\Entities\Blog;
use Modules\Blog\Entities\Category;
use Modules\Blog\Entities\Comment;
use Modules\Blog\Http\Requests\CreateBlog;
use Modules\Blog\Http\Requests\CreateComment;
use Modules\Blog\Http\Requests\DeleteBlog;
use Modules\Blog\Http\Requests\DeleteComment;
use Modules\Blog\Http\Requests\EditBlog;
use Modules\Core\Entities\Permissions;
use Modules\Core\Entities\User;
use phpDocumentor\Reflection\Types\Parent_;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;
use Yajra\DataTables\DataTables;
use Yajra\DataTables\Html\Builder;
use Nwidart\Modules\Facades\Module;
use Modules\Core\Http\Controllers\BaseController;
use Psy\Test\Exception\RuntimeExceptionTest;

class UserRoleController extends BaseController
{
    protected $htmlBuilder;

    public function __construct(Builder $htmlBuilder)
    {
        $this->htmlBuilder = $htmlBuilder;
        $this->htmlBuilder->parameters([
            'paging' => true,
            'searching' => true,
            'info' => false,
            'searchDelay' => 350,
            'language' => [
                'url' => Module::asset('core:datatable.json')
            ],
        ]);
        Parent::__construct();
    }
    public function index(Request $request)
    {

        if ($request->ajax()) {
            return DataTables::of(User::select(['id', 'fname','lname','created_at'])->orderBy('id','Desc'))
                ->addColumn('operation', function ($model) {
                    return  parent::redirectAction('user_role/edit?id='.$model->id, 'ویرایش', 'primary')
                        .parent::redirectAction(route('admin.core.user_role.delete', $model->id),'حذف','danger mr-1');
                })
                ->rawColumns(['operation'])
                ->make(true);
        }
        $object = ' کاربران';
        $html = $this->htmlBuilder
            ->addColumn(['data' => 'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' => 'fname', 'name' => 'fname', 'title' => 'نام '])
            ->addColumn(['data' => 'lname', 'name' => 'lname', 'title' => 'نام خانوادگی'])
            ->addColumn(['data' => 'operation', 'name' => 'operation', 'title' => 'عملیات']);
        return view('core::shared.datatable', compact(['html', 'object']));
    }

    public function create()
    {
        $data['model'] = new User();
        $data['route_action'] = 'core.user_role.store';
        return view('core::shared.add',$data);
    }
    /**
     * Store a newly created resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function storeuser(Request $request)
    {
        $request2=$request;
        $check= substr($request->mobile, 0, 1);
        if($check==0){
            $request2['mobile']=trim($request->mobile,0);
        }else{
            $request2['mobile']= $request->mobile;
        }
        $validator = Validator::make($request2->all(), [
            'email'=>'required|unique:users,email|email',
            'mobile'=>'required|unique:users,mobile'
        ]);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        $user = User::create($request->all());
        return redirect()->route('admin.core.user_role');
    }


    /**
     * Remove the specified resource from storage.
     * @param Request $request
     * @return Response
     */
    public function destroy(Request $request)
    {
        User::find($request->id)->delete();
        return redirect()->route('admin.core.user_role');
    }

    /**
     * Show the form for creating a new resource.
     * @return Response
     */
    public function add()
    {
        $data['model'] = new \Modules\Core\Entities\Role();
        $data['route_action'] = 'core.roles.store';
        return view('core::shared.add', $data);
    }

    /**
     * Store a newly created resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function store(Request $request)
    {
//        $blog=Auth::user()->blog()->create($request->all());
        $role = Role::create([
            'name' => $request->name,
        ]);
        $role->syncPermissions($request->permissions);
        return redirect()->route('admin.core.roles');
    }

    /**
     * Show the form for editing a new resource.
     * @param  Request $request
     * @return Response
     */
    public function showEdit(Request $request)
    {
        $data['data'] = User::find($request->id);
        $data['data']['role_id'] = $data['data']->getRoleNames()->first();
        $data['data']['role_id']=$data['data']['role_id']?Role::where('name',$data['data']['role_id'])->first()->id:0;
//        $data['data']['role_id'] = Role::where('name',$data['data']['role_id'])->first();
        $data['route_action'] = 'core.user_role.update';
        return view('core::shared.edit', $data);
    }

    /**
     * Show the form for editing the specified resource.
     * @param Request $request
     * @return Response
     */
    public function edit(Request $request)
    {
        $user = User::find($request->id);
        $user->update($request->all());
        $user->syncRoles([$request->role_id]);
        return redirect()->route('admin.core.user_role');
    }

    static public function roles(){
        $roles = Role::all()->pluck('name','id');
        $roles[0]='کاربر عادی';
        return $roles;
    }
}
