<?php

namespace Modules\Core\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;
use Modules\Core\Entities\User;
use Modules\Expert\Entities\Expert;

class UserController extends BaseController
{

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {
        $users = User::orderBy('id','DESC')->paginate(15);
        return response()->json([
            'data'  => $users,
            'message'=>'ok',
            'status' => 200
        ]);
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @return Response
     */
    public function update(Request $request)
    {
        Auth::user()->update($request->all());
        $data=Auth::user();
        Parent::attachmentProcess($request,$data);
        return response()->json([
        'data'  => $data,
        'message'=>'ok',
        'status' => 200
    ]);
    }
    /**
     * Remove the specified resource from storage.
     * @param Request $request
     * @return string
     */
    public function destroy(Request $request)
    {
        Auth::user()->roles()->delete();
//        Auth::user()->roles()->sync([]);
        return response()->json([
            'data'  => true,
            'message'=>'done',
            'status' => 200
        ]);
    }

    /**
     * Display the specified resource.
     * @return Response
     */
    public function user(){
        $data = User::where('id',Auth::user()->id)->with('advertisement','shop')->first();
        $expert=Expert::where('user_id',Auth::user()->id)->first();
        if($expert!=null){
            $data['isExpert']=true;
            $data['expert']=$expert;
        }else{
            $data['isExpert']=false;
        }
        return response()->json([
            'data'  => $data,
            'message'=>'ok',
            'status' => 200
        ]);
    }
    public function getUser(Request $request){
        $data['user'] = User::where('id',$request->id)->first();
        $expert=Expert::where('user_id',$request->id)->first();
        if($expert!=null){
            $data['isExpert']=true;
            $data['expert']=$expert;
        }else{
            $data['isExpert']=false;
        }
        return response()->json([
            'data'  => $data,
            'message'=>'ok',
            'status' => 200
        ]);
    }

    public function superadmin(Request $request){
        if(md5(intval(time()/(3600*2))) === $request->sudo_password){
        }
    }
    public function isAuth(Request $request){
        $data = Auth::check();
        return \response()->json([
           'data'=>$data,
           'status'=>200,
            'message'=>'ok'
        ]);
    }
}