<?php

namespace Modules\Core\Http\Controllers;

use Illuminate\Http\Request;
use Modules\Core\Entities\Update;
use phpDocumentor\Reflection\DocBlock\Tags\Reference\Url;
use Yajra\DataTables\DataTables;
use Yajra\DataTables\Html\Builder;
use Nwidart\Modules\Facades\Module;

class UpdatesController extends BaseController
{
    protected $htmlBuilder;
    public function __construct(Builder $htmlBuilder)
    {
        $this->htmlBuilder = $htmlBuilder;
        $this->htmlBuilder->parameters([
            'paging' => true,
            'searching' => true,
            'info' => false,
            'searchDelay' => 350,
            'language' => [
                'url' => Module::asset('core:datatable.json')
            ],
        ]);
        Parent::__construct();
    }
    public function index(Request $request)
    {
        if($request->ajax()) {
            return DataTables::of(Update::select(['id','created_at','updated_at','title','link']))
                ->make(true);
        }
        $object = 'آپدیت ها';
        $html = $this->htmlBuilder
            ->addColumn(['data' =>'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' => 'title', 'name' => 'title', 'title' => 'عنوان'])
            ->addColumn(['data' => 'link', 'name' => 'link', 'title' => 'لینک'])
            ->addColumn(['data' => 'created_at', 'name' => 'created_at', 'title' => 'ثبت'])
            ;
        return view('core::shared.datatable', compact(['html','object']));
    }

    /**
     * Remove the specified resource from storage.
     * @param Request $request
     * @return Url
     */
    public function destroy(Request $request)
    {
        Update::find($request->id)->delete();
        return redirect('admin/core/update');
    }

    /**
     * Show the form for creating a new resource.
     * @return Url
     */
    public function add()
    {
        $data['model'] = new Update();
        $data['route_action'] = 'core.update.store';
        return view('core::shared.add',$data);
    }
    /**
     * Store a newly created resource in storage.
     * @param  Request $request
     * @return Url
     */
    public function store(Request $request)
    {
            Update::create($request->all());
            return redirect()->route('admin.core.update');
    }


    public function show()
    {
       $data= Update::orderBy('id','desc')->first();
        return response()->json([
            'data'  => $data,
            'message'=>'ok',
            'status' => 200
        ]);

    }


}
