<?php

namespace Modules\Core\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Modules\Core\Entities\SpecialUser;
use Modules\Core\Entities\User;
use Yajra\DataTables\Html\Builder;
use Nwidart\Modules\Facades\Module;
use Yajra\DataTables\DataTables;

class SpecialUserController extends BaseController
{
    protected $htmlBuilder;
    public function __construct(Builder $htmlBuilder)
    {
        $this->htmlBuilder = $htmlBuilder;
        $this->htmlBuilder->parameters([
            'paging' => true,
            'searching' => true,
            'info' => false,
            'searchDelay' => 350,
            'language' => [
                'url' => Module::asset('core:datatable.json')
            ],
        ]);
        Parent::__construct();
    }
    public function index(Request $request)
    {
        if ($request->ajax()){
            return DataTables::of(SpecialUser::select(['id','user_id', 'created_at', 'updated_at']))
                ->editColumn('user_id', function($exp) {
                    return  $exp->user->fname . ' '.$exp->user->lname ;
                })
                ->addColumn('operation', function($exp) {
                    return parent::redirectAction('special_user/delete/'.$exp->id,'حذف','danger');
                })
                ->rawColumns(['operation'])
                ->make(true);
        }
        $object = 'کاربران ویژه';
        $html = $this->htmlBuilder
            ->addColumn(['data' =>'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' =>'user_id', 'name' => 'user_id', 'title' => 'نام کاربر'])
            ->addColumn(['data' => 'created_at', 'name' => 'created_at', 'title' => 'ثبت'])
            ->addColumn(['data' => 'updated_at', 'name' => 'updated_at', 'title' => 'ویرایش'])
            ->addColumn(['data' => 'operation', 'name' => 'operation', 'title' => 'عملیات']);
        return view('core::shared.datatable', compact(['html','object']));
    }
    /**
     * Remove the specified resource from storage.
     * @param Request $request
     * @return Response
     */
    public function destroy(Request $request)
    {
        SpecialUser::find($request->id)->delete();
        return redirect('admin/core/special_user');
    }

    /**
     * Show the form for creating a new resource.
     * @return Response
     */
    public function add()
    {
        $data['model'] = new SpecialUser();
        $data['route_action'] = 'core.special_user.store';
        return view('core::shared.add',$data);
    }
    /**
     * Store a newly created resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'user_id'=>'required|unique:special_users'
        ]);
        if ($validator->fails()) {
             return redirect('admin/core/special_user');
        }else{
            SpecialUser::create([
                'user_id' => $request->user_id,
            ]);
            return redirect()->route('admin.core.special_user');
        }
    }

    public function isSpecial()
    {
       if(Auth::user()){
           $check=SpecialUser::where('user_id',Auth::user()->id)->first();
           if($check==null){
               return response()->json([
                   'data'  => false,
                   'message'=>'not exist',
                   'status' => 400
               ]);
           }else{
               return response()->json([
                   'data'  => true,
                   'message'=>'ok',
                   'status' => 200
               ]);
           }
       }else{
           return response()->json([
               'data'  => false,
               'message'=>'not logged in',
               'status' => 400
           ]);
       }
    }

    static public function assign($json){
        $request=json_decode($json);
        $user_id=$request->user_id;
        SpecialUser::create([
            'user_id'=>$user_id
        ]);
    }

    static public function user()
    {
        $category = User::select('id', DB::raw('CONCAT(`fname`," " ,`lname`) as full_name'))->groupBy('id')->pluck('full_name', 'id');
        return $category;
    }
}
