<?php

namespace Modules\Core\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Modules\Blog\Entities\Blog;
use Modules\Blog\Entities\Category;
use Modules\Blog\Entities\Comment;
use Modules\Blog\Http\Requests\CreateBlog;
use Modules\Blog\Http\Requests\CreateComment;
use Modules\Blog\Http\Requests\DeleteBlog;
use Modules\Blog\Http\Requests\DeleteComment;
use Modules\Blog\Http\Requests\EditBlog;
use Modules\Core\Entities\Permissions;
use Modules\Core\Entities\User;
use phpDocumentor\Reflection\Types\Parent_;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;
use Yajra\DataTables\DataTables;
use Yajra\DataTables\Html\Builder;
use Nwidart\Modules\Facades\Module;
use Modules\Core\Http\Controllers\BaseController;
use Psy\Test\Exception\RuntimeExceptionTest;

class RolesController extends BaseController
{
    protected $htmlBuilder;

    public function __construct(Builder $htmlBuilder)
    {
        $this->htmlBuilder = $htmlBuilder;
        $this->htmlBuilder->parameters([
            'paging' => true,
            'searching' => true,
            'info' => false,
            'searchDelay' => 350,
            'language' => [
                'url' => Module::asset('core:datatable.json')
            ],
        ]);
        Parent::__construct();
    }

    public function index(Request $request)
    {
        if ($request->ajax()) {
            return DataTables::of(Role::select(['id', 'name']))
                ->addColumn('operation', function ($model) {
                    return parent::deleteAction($model->id) . parent::redirectAction(route('admin.core.roles.edit', $model->id), 'ویرایش', 'primary');
                })
                ->rawColumns(['operation'])
                ->make(true);
        }
        $object = 'دسترسی ها';
        $html = $this->htmlBuilder
            ->addColumn(['data' => 'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' => 'name', 'name' => 'name', 'title' => 'نام سطح دسترسی'])
            ->addColumn(['data' => 'operation', 'name' => 'operation', 'title' => 'عملیات']);

        return view('core::shared.datatable', compact(['html', 'object']));
    }

    /**
     * Remove the specified resource from storage.
     * @param DeleteBlog $request
     * @return Response
     */
    public function destroy(DeleteBlog $request)
    {
        Role::find($request->id)->delete();
        return redirect('admin/core/permissions');
    }

    /**
     * Show the form for creating a new resource.
     * @return Response
     */
    public function add()
    {
        $data['model'] = new \Modules\Core\Entities\Role();
        $data['route_action'] = 'core.roles.store';
        return view('core::shared.add', $data);
    }

    /**
     * Store a newly created resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function store(Request $request)
    {
        $role = Role::create([
            'name' => $request->name,
        ]);
        $role->syncPermissions($request->permissions);
        return redirect()->route('admin.core.roles');
    }

    /**
     * Show the form for editing a new resource.
     * @param  Request $request
     * @return Response
     */
    public function showEdit(Request $request)
    {
        $data['data'] = \Modules\Core\Entities\Role::find($request->id);
        $data['permissions'] = $data['data']->permissions->pluck('id');
        $data['route_action'] = 'core.roles.update';
        return view('core::shared.edit', $data);
    }
    /**
     * Show the form for editing the specified resource.
     * @param Request $request
     * @return Response
     */
    public function edit(Request $request)
    {
        $role = Role::find(($request->id));
        $role->update(['name'=>$request->name]);
        $perm_title=Permission::whereIn('id',$request->permissions)->get()->pluck('title');
        $perm_to_sync = Permissions::whereIn('title',$perm_title)->get()->pluck('id');
        $role->syncPermissions($perm_to_sync);

        return redirect()->route('admin.core.roles');
    }
}