<?php

namespace Modules\Core\Http\Controllers;

use Illuminate\Foundation\Auth\ThrottlesLogins;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\View;
use Nwidart\Modules\Facades\Module;
use Spatie\Permission\Models\Permission;

class CoreController extends BaseController
{
    /**
     * Display a listing of the resource.
     * @return Response
     */
    public function index()
    {
        $route_collection = Route::getRoutes()->getRoutesByName();
        foreach($route_collection as $index => $perm){
            if(explode('.',$index)[0] == 'admin'){
                if(Permission::where('name',$index)->first()){
                    continue;
                }else{

                    Permission::create(['name'=>$index,'title'=>'need_to_declare']);
                }
            }else{
                continue;
            }
        }
        foreach(Permission::all() as $index=>$perm){
            if(!isset($route_collection[$perm->name])){
                Permission::where('name',$perm->name)->first()->delete();
            }
        }
        return view('core::index');
    }
    public function login(){
        return view('core::template.login');
    }


    public function create()
    {
        return view('core::create');
    }
    /**
     * Store a newly created resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function store(Request $request)
    {
    }
    /**
     * Show the specified resource.
     * @return Response
     */
    public function show()
    {
        return view('core::show');
    }
    /**
     * Show the form for editing the specified resource.
     * @return Response
     */
    public function edit()
    {
        return view('core::edit');
    }

}
