<?php

namespace Modules\Core\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\View;
use Nwidart\Modules\Facades\Module;

class BaseController extends Controller
{
    public function __construct()
    {
        $sidebar=[];
        foreach(Module::toCollection() as $module){
            $sidebar[] = ['name'=> config(strtolower($module->name).'.fa_name'),'icon'=> config(strtolower($module->name).'.icon'),'subs'=>config(strtolower($module->name).'.subs')];
        }
        $data = explode('/',url()->current());
        $data = implode('/',array_splice($data,0,count($data)-1));
        View::share('sidebar', $sidebar);
        View::share('redirectBack', $data);
    }

    static public function attachmentProcess($request,$object){
        foreach ($request->file() as $name => $file) {
            if (is_array($file)) {
                $i = 0;
                foreach ($file as $item) {
                    $i++;
                    $path = $item->store($object->getTable());
                    $object->attachments()->updateOrCreate([
                        'filename' => $name . $i,
                    ],[
                        'path' => $path,
                        'mime' => $item->extension(),
                        'uid'=>uniqid($object->getTable())]);
                }
            } else {
                $path = $file->store($object->getTable());
                $object->attachments()->updateOrCreate([
                    'filename' => $name,
                ],[
                    'path' => $path,
                    'mime' => $file->extension(),
                    'uid'=>uniqid($object->getTable())]);
            }
        }
        return true;
    }

    static public function multi_attachments_process($request,$object){
        foreach ($request->file() as $name => $file) {
            if (is_array($file)) {
                $i = 0;
                foreach ($file as $item) {
                    $i++;
                    $path = $item->store($object->getTable());
                    $object->attachments()->create([
                        'filename' => $name . $i,
                        'path' => $path,
                        'mime' => $item->extension(),
                        'uid'=>uniqid($object->getTable())]);
                }
            } else {
                $path = $file->store($object->getTable());
                $object->attachments()->create([
                    'filename' => $name,
                    'path' => $path,
                    'mime' => $file->extension(),
                    'uid'=>uniqid($object->getTable())]);
            }
        }
        return true;
    }

    static public function documentProcess( $request,$object){
        foreach ($request->file() as $name => $file) {
            if (is_array($file)) {
                $i = 0;
                foreach ($file as $item) {
                    $i++;
                    $path = $item->store($object->getTable());
                    $object->documents()->updateOrCreate([
                        'filename' => $name . $i,
                    ],[
                        'path' => $path,
                        'mime' => $item->extension(),
                        'uid'=>uniqid($object->getTable())]);
                }
            } else {
                $path = $file->store($object->getTable());
                $object->documents()->updateOrCreate([
                    'filename' => $name,
                ],[
                    'path' => $path,
                    'mime' => $file->extension(),
                    'uid'=>uniqid($object->getTable())]);
            }
        }
        return true;
    }

    static public function redirectAction($href,$title,$btn_color='primary'){
        $html = '<a href="'.$href.'" class="btn btn-outline-'.$btn_color.' mr-1"> '.$title.' </a>' ;
        return $html;
    }

    static public function deleteAction($id){
        return '<button onclick="deleteAction('.$id.',this)" class="btn btn-outline-danger mr-1">حذف </button>';
    }

    static public function datatableModal($title,$html){
        $res = "<a href='#modalEdit' data-toggle='modal' data-html='";
        $res .= $html;
        $res .= "'>".$title.'</a>';
        return $res;
    }

    static public function selectValue($data){
        $class = explode('@',$data)[0];
        $function = explode('@',$data)[1];
        return $class::$function();
    }

    static public function sendMessage($message , $to){
        $txt="به فابریکا خوش آمدید
کد ورود شما : ".$message;
    $client = new \SoapClient("http://188.0.240.110/class/sms/wsdlservice/server.php?wsdl");
    $user = "f09124307101";
    $pass = "ag102976";
    $fromNum = "5000125475";
    $toNum = array($to);
    $pattern_code = "wkl9uqtunr";
    $input_data = array(
        "code" => $message
    );
    $client ->sendPatternSms($fromNum, $toNum, $user, $pass, $pattern_code, $input_data);
    }

    static public function paginateCollection($items, $perPage = 15, $page = null, $options = [])
    {
        $page = $page ?: (\Illuminate\Pagination\Paginator::resolveCurrentPage() ?: 1);
        $items = $items instanceof \Illuminate\Support\Collection ? $items : \Illuminate\Support\Collection::make($items);
        return new \Illuminate\Pagination\LengthAwarePaginator($items->forPage($page, $perPage), $items->count(), $perPage, $page, $options);
    }
}
