<?php

namespace Modules\Core\Entities;

use Elasticquent\ElasticquentTrait;
use Illuminate\Database\Eloquent\Model;

class State extends Model
{
    use ElasticquentTrait;
    use \Dimsav\Translatable\Translatable;

    protected $table = 'states';


    public $translatedAttributes = [
        'title',
        'description',
    ];

    protected $fillable = [
        'country_id',
        'position',
        'display',
    ];

    function country() {
        return $this->belongsTo(Country::class,'country_id');
    }

    function cities() {
        return $this->hasMany(City::class);
    }

//    function address(){
//        return $this->hasMany('App\UserAddress');
//    }
//
//    function logs(){
//        return $this->morphMany('App\LogAction','logable');
//    }

}
