<?php

namespace Modules\Blog\Entities;

use Elasticquent\ElasticquentTrait;
use Illuminate\Database\Eloquent\Model;
use Modules\Core\Entities\User;

class Like extends Model
{
    use ElasticquentTrait;
    protected $fillable = ['user_id', 'likable_id', 'likable_type', 'created_at', 'updated_at'];
    public function likable()
    {
        return $this->morphTo('likable');
    }
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

}
