<?php

namespace Modules\Blog\Entities;

use Elasticquent\ElasticquentTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;
use Modules\Blog\Http\Controllers\BlogController;
use Modules\Core\Entities\Attachment;
use Modules\Core\Entities\User;

class Blog extends Model
{
    use ElasticquentTrait;

    use SoftDeletes;
    protected $fillable = ['title', 'description', 'seo_title','seo_description','like','hit', 'content','user_id','blog_category_id', 'display'];
    protected $appends = ['attachments','liked','likes','commentcount'];
    function getLikedAttribute(){
        if(!Auth::user())
            return false;
        return $this->like()->where('user_id',Auth::user()->id)->get()->isNotEmpty();
    }
    function getLikesAttribute(){
            return $this->like()->count();
    }
    function getCommentcountAttribute(){
            return $this->comments()->count();
    }
    public function getAttachmentsAttribute()
    {
        if($this->attachments()==null){
            return [];
        }else{
            return $this->attachments()->get();
        }
    }
    function attachments(){
        return $this->morphMany(Attachment::class,'attachmentable');
    }
    public function category()
    {
        return $this->belongsTo(BlogCategory::class ,'blog_category_id');
    }
    public function user()
    {
        return $this->belongsTo(User::class ,'user_id');
    }
    public function comments()
    {
        return $this->morphMany(Comment::class,'commentable');
    }
    function like(){
        return $this->morphMany(Like::class,'likable');
    }
    public $adminFields=[
        'image'=>[
            'type'=>'photo',
            'fa_name'=>'عکس ',
            'col'=>12,
            'required'=>false,
            'data'=>[]
        ],
        'title'=>[
            'type'=>'string',
            'fa_name'=>'عنوان',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'description'=>[
            'type'=>'string',
            'fa_name'=>'توضیحات',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'seo_title'=>[
            'type'=>'string',
            'fa_name'=>'عنوان سئو',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'seo_description'=>[
            'type'=>'string',
            'fa_name'=>' توضیحات سئو',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'display'=>[
            'type'=>'select',
            'fa_name'=>'نمایش',
            'col'=>6,
            'required'=>false,
            'data'=>BlogController::class.'@display'
        ],
        'blog_category_id'=>[
            'type'=>'select',
            'fa_name'=>'دسته بندی بلاگ',
            'col'=>6,
            'required'=>true,
            'data'=>BlogController::class.'@category'
        ],
        'content'=>[
            'type'=>'text',
            'fa_name'=>'متن',
            'col'=>12,
            'required'=>true,
            'data'=>[]
        ],
    ];
}
