<?php

namespace Modules\Auction\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\BroadcastMessage;
use NotificationChannels\WebPush\WebPushChannel;
use NotificationChannels\WebPush\WebPushMessage;

class TenderCreate extends Notification
{
    use Queueable;

    public $tender_id=null;
    public $tender_category_id=null;

    public function __construct($tender_id,$tender_cat_id)
    {
        $this->tender_id=$tender_id;
        $this->tender_category_id=$tender_cat_id;
    }
    /**
     * Get the notification's delivery channels.
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return [WebPushChannel::class,'database','broadcast'];
    }
    public function toWebPush($notifiable, $notification)
    {
        return (new WebPushMessage)
            ->title('New Advertisement!')
//            ->icon('/approved-icon.png')
            ->body('Your account was approved!')
            ->data(['id' => $notification->id,'tender_id'=>$this->tender_id ]);
//            ->action('View account', 'view_account');
    }
    public function toBroadcast($notifiable)
    {
        return new BroadcastMessage([
//            'user_id'=>$this->user->id,
            'tender_id'=>$this->tender_id,
            'tender_category_id'=>$this->tender_category_id
        ]);
    }
    public function toDatabase($notifiable)
    {
        return new BroadcastMessage([
//          'user_id'=>$this->user->id,
            'tender_id'=>$this->tender_id,
            'tender_category_id'=>$this->tender_category_id

        ]);
    }
}
