<?php

Route::group(['middleware' => ['web','auth','acl'], 'prefix' => 'admin','as' => 'admin'], function()
{
    Route::group(['middleware' => 'web', 'prefix' => 'auction', 'namespace' => 'Modules\Auction\Http\Controllers' , 'as'=>'.auction'], function()
    {
        Route::group(['middleware' => 'web', 'prefix' => 'list','as' => '.list' ], function()
        {
            Route::get('/', 'AuctionController@index');
            Route::get('/delete','AuctionController@destroy')->name('.delete');
            Route::get('/create','AuctionController@add')->name('.create');
            Route::post('store', 'AuctionController@store')->name('.store');
            Route::get('/edit','AuctionController@edit')->name('.edit');
            Route::post('update/{id}', 'AuctionController@update')->name('.update');
        });

        Route::group(['middleware' => 'web','prefix' => 'category' , 'as'=>'.category'], function()
        {
            Route::group([ 'prefix' => 'list','as' => '.list'], function()
            {
                Route::get('/', 'AuctioncategoryController@index');
                Route::get('/delete','AuctioncategoryController@destroy')->name('.delete');
                Route::get('/create','AuctioncategoryController@add')->name('.create');
                Route::post('store', 'AuctioncategoryController@store')->name('.store');
                Route::get('/edit','AuctioncategoryController@edit')->name('.edit');
                Route::post('update/{id}','AuctioncategoryController@update')->name('.update');
            });
        });
    });
    Route::group(['middleware' => 'web', 'prefix' => 'tender', 'namespace' => 'Modules\Auction\Http\Controllers' , 'as'=>'.tender'], function()
    {
        Route::group(['middleware' => 'web', 'prefix' => 'list','as' => '.list' ], function()
        {
            Route::get('/', 'TenderController@index');
            Route::get('/delete','TenderController@destroy')->name('.delete');
            Route::get('/create','TenderController@add')->name('.create');
            Route::post('store', 'TenderController@store')->name('.store');
            Route::get('/edit','TenderController@edit')->name('.edit');
            Route::post('update/{id}', 'TenderController@update')->name('.update');
        });
        Route::group(['middleware' => 'web','prefix' => 'category' , 'as'=>'.category'], function()
        {
            Route::group([ 'prefix' => 'list','as' => '.list'], function()
            {
                Route::get('/', 'TendercategoryController@index');
                Route::get('/delete','TendercategoryController@destroy')->name('.delete');
                Route::get('/create','TendercategoryController@add')->name('.create');
                Route::post('store', 'TendercategoryController@store')->name('.store');
                Route::get('/edit','TendercategoryController@edit')->name('.edit');
                Route::post('update/{id}','TendercategoryController@update')->name('.update');
            });
        });
    });
});
//front-end routes

Route::group([ 'prefix' => 'auction', 'namespace' => 'Modules\Auction\Http\Controllers','middleware' => 'web'], function()
{
    Route::get('/search','AuctionController@search');
    Route::post('/show','AuctionController@show');
    Route::get('/show-all', 'AuctionController@showAll')->name('.showAll');
    Route::get('/list','AuctionController@list');
    Route::get('/category/show','AuctionController@show');
    Route::post('/category/auction','AuctionController@auction');
});

Route::group([ 'prefix' => 'tender', 'namespace' => 'Modules\Auction\Http\Controllers','middleware' => 'web'], function()
{
    Route::get('/search','TenderController@search');
    Route::post('/show','TenderController@show');
    Route::get('/show-all', 'TenderController@showAll')->name('.showAll');
    Route::get('/lists', 'TenderController@lists')->name('.lists');
    Route::get('/list','TenderController@list');
    Route::get('/category','TendercategoryController@show');
    Route::post('/category/tender','TendercategoryController@tender');

});