<?php

namespace Modules\Auction\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;

use Modules\Auction\Entities\Tender;
use Modules\Auction\Entities\TenderCategory;

use Modules\Core\Http\Controllers\BaseController;
use Nwidart\Modules\Facades\Module;
use Yajra\DataTables\Html\Builder;
use Yajra\DataTables\DataTables;

class TendercategoryController extends BaseController
{
    protected $htmlBuilder;
    public function __construct(Builder $htmlBuilder)
    {
        $this->htmlBuilder = $htmlBuilder;
        $this->htmlBuilder->parameters([
            'paging' => true,
            'searching' => true,
            'info' => false,
            'searchDelay' => 350,
            'language' => [
                'url' => Module::asset('core:datatable.json')
            ],
        ]);
        Parent::__construct();
    }
    public function index(Request $request)
    {
        if ($request->ajax()) {
            return DataTables::of(TenderCategory::select(['id','title','description', 'created_at', 'updated_at']))
                ->addColumn('operation', function($category) {
                    return parent::redirectAction('list/delete?id='.$category->id,'حذف','danger mr-1')
                        .parent::redirectAction('list/edit?id='.$category->id,'ویرایش','warning mr-1');
                })
                ->rawColumns(['operation'])
                ->make(true);
        }
        $object = 'دسته بندی مناقصه ها';
        $html = $this->htmlBuilder
            ->addColumn(['data' =>'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' => 'title', 'name' => 'title', 'title' => 'عنوان'])
            ->addColumn(['data' => 'description', 'name' => 'description', 'title' => 'توضیحات'])
            ->addColumn(['data' => 'created_at', 'name' => 'created_at', 'title' => 'ثبت'])
            ->addColumn(['data' => 'updated_at', 'name' => 'updated_at', 'title' => 'ویرایش'])
            ->addColumn(['data' => 'operation', 'name' => 'operation', 'title' => 'عملیات']);

        return view('core::shared.datatable', compact(['html','object']));
    }
    /**
     * Show the form for creating a new resource.
     * @return Response
     */
    public function add()
    {
        $data['model'] = new TenderCategory();
        $data['route_action'] = 'tender.category.list.store';
        return view('core::shared.add',$data);
    }
    /**
     * Store a newly created resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function store(Request $request)
    {
        $category=TenderCategory::create([
            'title' => $request->title,
            'description' =>$request->description,
        ]);
        Parent::attachmentProcess($request,$category);
        return redirect()->route('admin.tender.category.list');
    }
    /**
     * Show the form for creating a new resource.
     * @param Request $request
     * @return Response
     */
    public function create(Request $request)
    {
        $cat=TenderCategory::create([
            'title' => $request->title,
            'description' => $request->description,
        ]);
        return response()->json([
            'data' =>$cat,
            'message'=>'done',
            'status' => 200
        ]);
    }
    /**
     * Show the specified resource.
     * @return Response
     */
    public function show()
    {
        $list=TenderCategory::orderBy('id','desc')->get();
        return response()->json([
            'data' =>$list,
            'message'=>'ok',
            'status' => 200
        ]);
    }

    /**
     * Show the form for editing a new resource.
     * @param  Request $request
     * @return Response
     */
    public function edit(Request $request)
    {
        $data['route_action'] = 'tender.category.list.update';
        $data['data']=TenderCategory::find($request->id);
        return view('core::shared.edit', $data);
    }
    /**
     * Update the specified resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function update(Request $request)
    {
        $cat = TenderCategory::find(($request->id))->update($request->all());
        $data=TenderCategory::find(($request->id));
        Parent::attachmentProcess($request,$data);

        return redirect()->route('admin.tender.category.list');
    }
    /**
     * Remove the specified resource from storage.
     * @param  Request $request
     * @return Response
     */
    public function destroy(Request $request)
    {
        TenderCategory::find(($request->id))->delete();
        return redirect('admin/tender/category/list');
    }
}
