<?php

namespace Modules\Auction\Entities;

use Elasticquent\ElasticquentTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;
use Modules\Auction\Http\Controllers\TenderController;
use Modules\Blog\Entities\Comment;
use Modules\Blog\Entities\Like;
use Modules\Core\Entities\Attachment;
use Modules\Core\Entities\User;

class Tender extends Model
{
    use ElasticquentTrait;
    use SoftDeletes;
    protected $fillable = ['title', 'description', 'seo_title','seo_description', 'like','hit','content','user_id','tender_category_id', 'display','time'];
    protected $appends = ['attachmentsImage','attachmentsVideo','liked','likes','commentcount'];
    function getLikedAttribute(){
        if(!Auth::user())
            return false;
        return $this->like()->where('user_id',Auth::user()->id)->get()->isNotEmpty();
    }
    function getLikesAttribute(){
        return $this->like()->count();
    }
    function getCommentcountAttribute(){
        return $this->comments()->count();
    }
    public function getAttachmentsImageAttribute()
    {
        if($this->attachments()){
            return $this->attachments()
                ->whereIn('mime',['png','jpeg','jpg'])
                ->orderBy('id','desc')
                ->get();
        }else{
            return [];
        }
    }
    public function getAttachmentsVideoAttribute()
    {
        if($this->attachments()){
            return $this->attachments()->where('mime','mp4')->orderBy('id','desc')->get();
        }else{
            return [];
        }
    }
    function attachments(){
        return $this->morphMany(Attachment::class,'attachmentable');
    }
    public function category()
    {
        return $this->belongsTo(TenderCategory::class ,'tender_category_id');
    }
    public function user()
    {
        return $this->belongsTo(User::class ,'user_id');
    }
    public function comments()
    {
        return $this->morphMany(Comment::class,'commentable');
    }
    function like(){
        return $this->morphMany(Like::class,'likable');
    }
    public $adminFields=[
        'image'=>[
            'type'=>'photo',
            'fa_name'=>'عکس ',
            'col'=>12,
            'required'=>false,
            'data'=>[]
        ],
        'title'=>[
            'type'=>'string',
            'fa_name'=>'عنوان',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'description'=>[
            'type'=>'string',
            'fa_name'=>'توضیحات',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'seo_title'=>[
            'type'=>'string',
            'fa_name'=>'عنوان سئو',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'seo_description'=>[
            'type'=>'string',
            'fa_name'=>' توضیحات سئو',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'time'=>[
            'type'=>'dateTime',
            'fa_name'=>'زمان پایان مناقصه',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'display'=>[
            'type'=>'select',
            'fa_name'=>'نمایش',
            'col'=>6,
            'required'=>false,
            'data'=>TenderController::class.'@display'
        ],
        'tender_category_id'=>[
            'type'=>'select',
            'fa_name'=>'دسته بندی مناقصه',
            'col'=>6,
            'required'=>true,
            'data'=>TenderController::class.'@category'
        ],
        'content'=>[
            'type'=>'text',
            'fa_name'=>'متن',
            'col'=>12,
            'required'=>true,
            'data'=>[]
        ],
    ];
}