<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAuctionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('auctions', function (Blueprint $table) {
            $table->increments('id');
            $table->string('title');
            $table->string('description');
            $table->string('seo_title');
            $table->string('seo_description');
            $table->text('content');
            $table->dateTime('time');
            $table->unsignedInteger('user_id');
            $table->unsignedInteger('auction_category_id')->nullable();
            $table->tinyInteger('display')->default(1);
            $table->integer('like')->default(0);
            $table->integer('hit')->default(0);
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('auctions');
    }
}
