
@extends('core::layouts.master')
@section('head')


    <link href="{{Module::asset('core:node_modules/nestable/jquery-nestable.css')}}" rel="stylesheet"/>
    <link rel="stylesheet" href="{{Module::asset('core:node_modules/select2/dist/css/select2.min.css')}}"/>
    <link rel="stylesheet" href="{{Module::asset('core:node_modules/select2-bootstrap-theme/dist/select2-bootstrap.min.css')}}"/>
    <link rel="stylesheet" href="{{Module::asset('core:node_modules/icheck/skins/all.css')}}"/>
    <link rel="stylesheet" href="{{Module::asset('core:node_modules/jquery-tags-input/dist/jquery.tagsinput.min.css')}}">
    <link rel="stylesheet" href="{{Module::asset('core:node_modules/dropify/dist/css/dropify.min.css')}}">
    <link rel="stylesheet" href="{{Module::asset('core:css/persian-datepicker.min.css')}}">

@endsection
@section('content')
    <div class="content-wrapper">
        @include('core::layouts.breadcrumb')
        <div class="row">
            <div class="col-12 grid-margin">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6"><h4 class="card-title">ویرایش آگهی</h4></div>
                            <div class="col-md-6 text-left"><a href="/admin/advertisement/list" class="btn btn-warning">بازگشت به لیست</a></div>
                        </div>

                        <form method="post" action="{{route('admin.'.$route_action,isset($params)?$params:[])}}" enctype="multipart/form-data">
                            @csrf


                            <div class="row">
                                @foreach($data['attachments'] as $attachment)
                                    <div class="col-sm-4 mt-1"><input type="file" class="dropify" name="image[]" data-max-file-size="{{$data['category']->upload}}K" data-default-file="/files?uid={{$attachment->uid}}" /></div>
                                @endforeach
                                @for($i = 0;$i<($data['category']->limit - count($data['attachments']));$i++)
                                        <div class="col-sm-4 mt-1"><input type="file" class="dropify" name="image[]" data-max-file-size="{{$data['category']->upload}}K" /></div>
                                    @endfor
                            </div>
                            <div class="d-flex">
                                @foreach($data['attachments'] as $attachment)
                                    <img src="/files?uid={{$attachment->uid}}&width=200&height=200" class="m-1" />
                                @endforeach
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group pt-3">
                                        <label>انتخاب استان</label>
                                        <div class="mt-1">
                                            <select class="js-example-basic-single w-100" onchange="setState(this.value)">
                                                <option disabled selected>انتخاب نشده</option>
                                                @foreach($state as $item)
                                                    <option value="{{$item->id}}" @if($item->id == $data->state->state_id) selected @endif>{{$item->title}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group pt-3">
                                        <label>انتخاب شهر</label>
                                        <div class="mt-1">
                                            <select class="js-example-basic-single w-100" id="cities" name="city_id">
                                                @php $stateCities = $data['state']['cites']@endphp
                                            @foreach($stateCities as $item)
                                                    <option value="{{$item->city_id}}" @if($item->city_id == $data->city->id) selected @endif>{{$item->title}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                @if($data['data'])
                                @foreach(json_decode($data['data']) as $key => $value)
                                    @php $itm=\Modules\Advertisement\Entities\CategoryItem::find($key);@endphp
                                        <div class="col-md-6">
                                            <div class="form-group pt-3">
                                                @if($itm->type == 'text')
                                                    <label>{{$itm->title}}</label>
                                                    <input name="datas[{{$itm->id}}]" type="text" class="form-control mt-1"  placeholder="{{$itm->title}}" value="{{$value}}">
                                                @elseif($itm->type == 'text-box')
                                                    <label>{{$itm->title}}</label>
                                                    <textarea name="datas[{{$itm->id}}]" class="form-control mt-1"  placeholder="{{$itm->title}}">{{$value}}</textarea>
                                                @elseif($itm->type == 'select')
                                                    <label>{{$itm->title}}</label>
                                                    <div class="mt-1">
                                                        <select class="js-example-basic-single w-100" name="datas[{{$itm->id}}]" >
                                                            @foreach(json_decode($itm->data) as $option)
                                                                <option value="{{$option}}" @if($option==$value) selected @endif>{{$option}}</option>
                                                                @endforeach
                                                        </select>
                                                    </div>
                                                @else
                                                    <label>{{$itm->title}}</label>
                                                    <div class="mt-1">
                                                        <label class="switch"><input name="datas[{{$itm->id}}]" type="hidden" value="0">
                                                            <input name="datas[{{$itm->id}}]" type="checkbox" @if($value == 1)checked @endif value="1">
                                                            <span class="slider round"></span>
                                                        </label>
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                    @endforeach
                                    @endif
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group pt-3">
                                        <label>عنوان </label>
                                        <input name="title" type="text" class="form-control mt-1" placeholder="عنوان" value="{{$data->title}}">
                                    </div>
                                </div>
                                {{--<div class="col-md-6">--}}
                                    {{--<div class="form-group pt-3">--}}
                                        {{--<label>قیمت </label>--}}
                                        {{--<input name="price" type="text" class="form-control mt-1" placeholder="قیمت" value="{{$data->price}}">--}}
                                    {{--</div>--}}
                                {{--</div>--}}
                                <div class="col-md-6">
                                    <div class="form-group pt-3">
                                        <label>نوع </label>
                                        <div class="mt-1">
                                            <select class="js-example-basic-single w-100" name="type">
                                                <option value="rent" @if($data->type == "rent") selected @endif>اجاره</option>
                                                <option value="sale" @if($data->type == "sale") selected @endif>فروش</option>
                                                <option value="buy" @if($data->type == "buy") selected @endif>خرید</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group pt-3">
                                        <label>تاریخ انقضا</label>
                                        <input  name="expiration_time" placeholder="تاریخ انقضا" class="form-control mt-1 persianDate" value="{{$data->expiration_time}}"  />
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label>فعال</label>
                                    <div class="mt-1">
                                        <label class="switch"><input name="status" type="hidden" value="0">
                                            <input name="status" type="checkbox" @if($data->status == 1)checked @endif value="1">
                                            <span class="slider round"></span>
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label>تایید نمایش</label>
                                    <div class="mt-1">
                                        <label class="switch"><input name="accept" type="hidden" value="0">
                                            <input name="accept" type="checkbox" @if($data->accept == 1)checked @endif value="1">
                                            <span class="slider round"></span>
                                        </label>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group pt-3">
                                        <label>نوع </label>
                                        <div class="mt-1">
                                            <select class="js-example-basic-single w-100" name="type">
                                                <option value="rent" @if($data->type == "rent") selected @endif>اجاره</option>
                                                <option value="sale" @if($data->type == "sale") selected @endif>فروش</option>
                                                <option value="buy" @if($data->type == "buy") selected @endif>خرید</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>


                                <div class="col-md-6">
                                    <label>اولویت</label>
                                    <select name="priority" class="js-example-basic-single w-100">
                                        <option value="immediate" @if($data->priority == "immediate") selected @endif>فوری</option>
                                        <option value="special" @if($data->priority == "special") selected @endif>ویژه</option>
                                        <option value="normal" @if($data->priority == "normal") selected @endif>عادی</option>
                                        <option value="immediate-special" @if($data->priority == "immediate-special") selected @endif>ویژه و فوری</option>

                                    </select>
                                </div>
                                <div class="col-md-6">0
                                    <label>قابلیت پیشنهاد دادن</label>
                                    <div class="mt-1">
                                        <label class="switch"><input name="offer" type="hidden" value="0">
                                            <input name="offer" type="checkbox" @if($data->offer == 1)checked @endif value="1">
                                            <span class="slider round"></span>
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <label>توضیحات</label>
                                    <textarea class="form-control mt-1" name="description">{{$data->description}}</textarea>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div id="googleMap" style="width:100%;height:400px;margin-top:20px"></div>
                                    <input type="hidden" id="lat" name="latitude" value="{{$data['latitude']}}" />
                                    <input type="hidden" id="lng" name="longitude" value="{{$data['longitude']}}" />
                                </div>
                            </div>
                            <div class="text-left" style="margin-top:20px">
                                <button class="btn btn-success" type="submit">ثبت</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')

    <script src="{{Module::asset('core:node_modules/jquery-bar-rating/dist/jquery.barrating.min.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/raphael/raphael.min.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/jquery-sparkline/jquery.sparkline.min.js')}}"></script>
    <script src="{{Module::asset('core:js/jquery-sortable.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/nestable/jquery.nestable.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/select2/dist/js/select2.min.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/icheck/icheck.min.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/jquery-tags-input/dist/jquery.tagsinput.min.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/dropify/dist/js/dropify.min.js')}}"></script>
    <script src="{{Module::asset('core:ckeditor/ckeditor.js')}}"></script>

    <script src="{{Module::asset('core:js/iCheck.js')}}"></script>

    <script>


        if($('#xeditor').length){
            CKEDITOR.replace('xeditor');
        }
        $(function () {
            $(".js-example-basic-single").select2({dir: 'rtl', placeholder: "انتخاب نشده"});
            $(".js-example-basic-multiple").select2({dir:'rtl',placeholder: "انتخاب نشده"});
            $('#editModal').on('shown.bs.modal', function (e) {
                $(".js-example-basic-single").select2({dir: 'rtl', placeholder: "انتخاب نشده"});
                $(".js-example-basic-multiple").select2({dir:'rtl',placeholder: "انتخاب نشده"});
            })

            $('#tags').tagsInput({
                'width': '100%',
                'height': '100%',
                'interactive': true,
                'defaultText': 'اضافه کردن',
                'removeWithBackspace': true,
                'minChars': 0,
                'maxChars': 20, // if not provided there is no limit
                'placeholderColor': '#666666'
            });

            $('#tags2').tagsInput({
                'width': '100%',
                'height': '100%',
                'interactive': true,
                'defaultText': 'اضافه کردن',
                'removeWithBackspace': true,
                'minChars': 0,
                'maxChars': 20, // if not provided there is no limit
                'placeholderColor': '#666666'
            });
            $('.icon-plus').on('click', function () {
                $('.attachments').append('<div class="pt-3"> <input type="file" class="dropify" /></div>')
                $('.dropify').dropify();
            })
        });
        $(document).on('keyup','#pSearchInput',function(){
            let input = $('#pSearchInput')
            if(input.val().length){
                $('.perm').hide()
                $('div[data-search*='+input.val()+']').show()
            }else{
                $('.perm').show()
            }
        })
    </script>
    <script src="{{Module::asset('core:/js/dropify.js')}}"></script>
    <script src="{{Module::asset('core:js/persian-date.min.js')}}"></script>
    <script src="{{Module::asset('core:js/persian-datepicker.min.js')}}"></script>
    <script>
        $('.persianDate').persianDatepicker({
            autoClose: true,
            onSelect:function(val){
                $('.persianDate').val(new persianDate(val).toCalendar('gregorian').toLocale('en').format('YYYY-MM-DD'))
            },
            formatter: function(unix){
                return new persianDate(unix).toCalendar('gregorian').toLocale('en').format('YYYY-MM-DD')
            }
        });
        function setState(val) {
            $.get('/advertisement/data-cities/'+val,function (res) {
                var city = '<option disabled selected>انتخاب نشده</option>'
                res.forEach(function (e) {
                    city +='<option value='+e.city_id+'>'+e.title+'</option>'
                })
                $('#cities').html(city)
            })
        }
        $(".js-example-basic-single").select2({dir:'rtl',placeholder: "انتخاب نشده"});
        if ($("#ul-slider-1").length) {
            var bigValueSlider = document.getElementById('ul-slider-1'),
                bigValueSpan = document.getElementById('huge-value');

            noUiSlider.create(bigValueSlider, {
                start: 100,
                step: 10,
                direction: 'rtl',
                connect: [true, false],
                range: {
                    min: 10,
                    max: 100
                }
            });
            bigValueSlider.noUiSlider.on('update', function(values, handle) {
//                  console.log(range[Math.floor(values);

                bigValueSpan.innerHTML = Math.floor(values);
            });
        }
        if ($("#ul-slider-2").length) {
            var bigValueSlider2 = document.getElementById('ul-slider-2'),
                bigValueSpan2 = document.getElementById('huge2-value');

            noUiSlider.create(bigValueSlider2, {
                start: 100,
                step: 10,
                direction: 'rtl',
                connect: [true, false],
                range: {
                    min: 10,
                    max: 100
                }
            });
            bigValueSlider2.noUiSlider.on('update', function(values, handle) {
//                  console.log(range[Math.floor(values);

                bigValueSpan2.innerHTML = Math.floor(values);
            });
        }
        $('#tags').tagsInput({
            'width': '100%',
            'height': '100%',
            'interactive': true,
            'defaultText': 'اضافه کردن',
            'removeWithBackspace': true,
            'minChars': 0,
            'maxChars': 20, // if not provided there is no limit
            'placeholderColor': '#666666'
        });
    </script>
    <script>
        function myMap() {
            var mapProp= {
                center:new google.maps.LatLng(@if($data['latitude'] && $data['longitude']){{$data['latitude']}},{{$data['longitude']}}@else 35.6970118,51.2097354 @endif),
                    zoom:7,
        };
            var map=new google.maps.Map(document.getElementById("googleMap"),mapProp);
            var marker = new google.maps.Marker({
                position: mapProp.center,
                map: map,
                draggable:true,
            });
            map.addListener('click', function (event) {
                placeMarker(map,marker,event.latLng);
            });
            marker.addListener('dragend',function (event) {
                placeMarker(map,marker,event.latLng)
            })
        }
        function placeMarker(map,marker,location) {
            marker.setPosition(location)
            $('#lat').val(location.lat())
            $('#lng').val(location.lng())
        }
    </script>
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCsT_7eLUr_uriW0-bkVG60zXmDvf2e8fY&callback=myMap"></script>
@endsection
