@extends('core::layouts.master')
@section('head')


    <link href="{{Module::asset('core:node_modules/nestable/jquery-nestable.css')}}" rel="stylesheet"/>
    <link rel="stylesheet" href="{{Module::asset('core:node_modules/select2/dist/css/select2.min.css')}}"/>
    <link rel="stylesheet" href="{{Module::asset('core:node_modules/select2-bootstrap-theme/dist/select2-bootstrap.min.css')}}"/>
    <link rel="stylesheet" href="{{Module::asset('core:node_modules/icheck/skins/all.css')}}"/>
    <link rel="stylesheet" href="{{Module::asset('core:node_modules/jquery-tags-input/dist/jquery.tagsinput.min.css')}}">
    <link rel="stylesheet" href="{{Module::asset('core:node_modules/dropify/dist/css/dropify.min.css')}}">
    <link rel="stylesheet" href="{{Module::asset('core:css/persian-datepicker.min.css')}}">

@endsection
@section('content')
    <div class="content-wrapper">
        @include('core::layouts.breadcrumb')
        <div class="row">
            <div class="col-12 grid-margin">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6"><h4 class="card-title">افزودن آگهی</h4></div>
                            <div class="col-md-6 text-left"><a href="/admin/advertisement/list" class="btn btn-warning">بازگشت به لیست</a></div>
                        </div>
                        <form method="post" action="{{route('admin.'.$route_action,isset($params)?$params:[])}}" enctype="multipart/form-data">
                            @csrf

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group pt-3">
                                        <label>انتخاب دسته بندی</label>
                                        <div class="mt-1">
                                            <select required class="js-example-basic-single w-100" onchange="setSubCat(this.value)">
                                                <option disabled selected value="">انتخاب نشده</option>
                                                @foreach($categories as $category)
                                                    <option value="{{$category->id}}">{{$category->title}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group pt-3">
                                        <label>انتخاب زیر دسته</label>
                                        <div class="mt-1">
                                            <select required class="js-example-basic-single w-100" id="subCat" onchange="setFields(this.value)">
                                                <option disabled selected value="">انتخاب نشده</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group pt-3">
                                        <label>انتخاب استان</label>
                                        <div class="mt-1">
                                            <select required class="js-example-basic-single w-100" onchange="setState(this.value)">
                                                <option disabled selected value="">انتخاب نشده</option>
                                                @foreach($state as $item)
                                                    <option value="{{$item->id}}">{{$item->title}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group pt-3">
                                        <label>انتخاب شهر</label>
                                        <div class="mt-1">
                                            <select class="js-example-basic-single w-100" id="cities" name="city_id">
                                                <option disabled selected value="">ابتدا استان مورد نظر را وارد نمایید</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group pt-3">
                                        <label>عنوان </label>
                                        <input name="title" type="text" class="form-control mt-1" placeholder="عنوان">
                                    </div>
                                </div>

                                {{--<div class="col-md-6">--}}
                                    {{--<div class="form-group pt-3">--}}
                                        {{--<label>قیمت </label>--}}
                                        {{--<input name="price" type="text" class="form-control mt-1" placeholder="قیمت">--}}
                                    {{--</div>--}}
                                {{--</div>--}}

                                <div class="col-md-6">
                                    <div class="form-group pt-3">
                                        <label>نوع </label>
                                        <div class="mt-1">
                                            <select class="js-example-basic-single w-100" name="type">
                                                <option value="rent">اجاره</option>
                                                <option value="sale">فروش</option>
                                                <option value="buy">خرید</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label>فعال</label>
                                    <div class="mt-1">
                                        <label class="switch"><input name="status" type="hidden" value="0">
                                            <input name="status" type="checkbox" checked value="1">
                                            <span class="slider round"></span>
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label>تایید نمایش</label>
                                    <div class="mt-1">
                                        <label class="switch"><input name="accept" type="hidden" value="0">
                                            <input name="accept" type="checkbox"  value="1">
                                            <span class="slider round"></span>
                                        </label>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <label>اولویت</label>
                                    <select name="priority" class="js-example-basic-single w-100">
                                            <option value="immediate">فوری</option>
                                            <option value="special">ویژه</option>
                                            <option value="normal">عادی</option>
                                            <option value="immediate-special">ویژه و فوری</option>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label>قابلیت پیشنهاد دادن</label>
                                    <div class="mt-1">
                                        <label class="switch"><input name="offer" type="hidden" value="0">
                                            <input name="offer" type="checkbox" value="1">
                                            <span class="slider round"></span>
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <label>توضیحات</label>
                                    <textarea required class="form-control mt-1" name="description"></textarea>
                                </div>
                            </div>
                            <div class="row" id="imgParent"></div>
                            <div class="row" id="dataParent"></div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div id="googleMap" style="width:100%;height:400px;margin-top:20px"></div>
                                    <input type="hidden" id="lat" name="latitude" value="35.6970118" />
                                    <input type="hidden" id="lng" name="longitude" value="51.2097354" />
                                </div>
                            </div>
                            <div class="text-left">
                                <button class="btn btn-success" type="submit">ثبت</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')

    <script src="{{Module::asset('core:node_modules/jquery-bar-rating/dist/jquery.barrating.min.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/raphael/raphael.min.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/jquery-sparkline/jquery.sparkline.min.js')}}"></script>
    <script src="{{Module::asset('core:js/jquery-sortable.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/nestable/jquery.nestable.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/select2/dist/js/select2.min.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/icheck/icheck.min.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/jquery-tags-input/dist/jquery.tagsinput.min.js')}}"></script>
    <script src="{{Module::asset('core:node_modules/dropify/dist/js/dropify.min.js')}}"></script>
    <script src="{{Module::asset('core:ckeditor/ckeditor.js')}}"></script>

    <script src="{{Module::asset('core:js/iCheck.js')}}"></script>

    <script>


        if($('#xeditor').length){
            CKEDITOR.replace('xeditor');
        }
        $(function () {
            $(".js-example-basic-single").select2({dir: 'rtl', placeholder: "انتخاب نشده"});
            $(".js-example-basic-multiple").select2({dir:'rtl',placeholder: "انتخاب نشده"});
            $('#editModal').on('shown.bs.modal', function (e) {
                $(".js-example-basic-single").select2({dir: 'rtl', placeholder: "انتخاب نشده"});
                $(".js-example-basic-multiple").select2({dir:'rtl',placeholder: "انتخاب نشده"});
            })

            $('#tags').tagsInput({
                'width': '100%',
                'height': '100%',
                'interactive': true,
                'defaultText': 'اضافه کردن',
                'removeWithBackspace': true,
                'minChars': 0,
                'maxChars': 20, // if not provided there is no limit
                'placeholderColor': '#666666'
            });

            $('#tags2').tagsInput({
                'width': '100%',
                'height': '100%',
                'interactive': true,
                'defaultText': 'اضافه کردن',
                'removeWithBackspace': true,
                'minChars': 0,
                'maxChars': 20, // if not provided there is no limit
                'placeholderColor': '#666666'
            });
            $('.icon-plus').on('click', function () {
                $('.attachments').append('<div class="pt-3"> <input type="file" class="dropify" /></div>')
                $('.dropify').dropify();
            })
        });
        $(document).on('keyup','#pSearchInput',function(){
            let input = $('#pSearchInput')
            if(input.val().length){
                $('.perm').hide()
                $('div[data-search*='+input.val()+']').show()
            }else{
                $('.perm').show()
            }
        })
    </script>
    <script src="{{Module::asset('core:/js/dropify.js')}}"></script>
    <script src="{{Module::asset('core:js/persian-date.min.js')}}"></script>
    <script src="{{Module::asset('core:js/persian-datepicker.min.js')}}"></script>
    <script>
        $(".js-example-basic-single").select2({dir:'rtl',placeholder: "انتخاب نشده"});

        function setSubCat(val) {
            $.get('/advertisement/sub-category/'+val,function (res) {
                var sub = '<option disabled selected>انتخاب نشده</option>'
                res.forEach(function (e) {
                    sub +='<option value='+e.id+'>'+e.title+'</option>'
                })
                $('#subCat').html(sub)
            })
        }
        function setState(val) {
            $.get('/advertisement/data-cities/'+val,function (res) {
                var city = '<option disabled selected>انتخاب نشده</option>'
                res.forEach(function (e) {
                    city +='<option value='+e.city_id+'>'+e.title+'</option>'
                })
                $('#cities').html(city)
            })
        }
        var fileSize
        function setFields(val) {
            $.get('/advertisement/data-category/'+val,function (res) {
                var data = ''
                var subData = ''
                var imgs = ''
                data += `<input type="hidden" name="category_id" value="`+res.id+`" />`
                data += `
                    <div class="col-md-6">
                                        <div class="form-group pt-3">
                                            <label>تاریخ انقضا
                    </label>
                    <input  name="expiration_time" placeholder="تاریخ انقضا" class="form-control mt-1 persianDate" value=`+res.expiration_time+` />
                                        </div>
                                    </div>
                `
                for (var i = 0; i < res.limit; i++) {
                    imgs += `
                    <div class="col-sm-4 mt-1"><input type="file" class="dropify" name="image[]" data-max-file-size="`+res.upload+`K" /></div>
                    `
                }
                res.items.forEach(function (e) {
                    if(e.type == 'text'){
                        data += `
                            <div class="col-md-6">
                                <div class="form-group pt-3">
                                    <label>`+e.title+`</label>
                                    <input name="datas[`+e.id+`]" type="text" class="form-control mt-1"  placeholder="`+e.placeholder+`">
                                </div>
                            </div>
                        `
                    }else if(e.type == 'text-box'){
                        data += `
                            <div class="col-md-6">
                                <div class="form-group pt-3">
                                    <label>`+e.title+`</label>
                                    <textarea name="datas[`+e.id+`]" class="form-control mt-1"  placeholder="`+e.placeholder+`"></textarea>
                                </div>
                            </div>
                        `
                    }else if(e.type == 'select'){
                        JSON.parse(e.data).forEach(function (o) {
                            subData += '<option value='+o+'>'+o+'</option>'
                        })
                        data +=`
                            <div class="col-md-6">
                                <div class="form-group pt-3">
                                        <label>`+e.title+`</label>
                                        <div class="mt-1">
                                            <select class="js-example-basic-single w-100" name="datas[`+e.id+`]" >`+subData+

                                `

                                            </select>
                                        </div>
                                    </div>
                            </div>
                        `
                        setTimeout(function () {
                            $(".js-example-basic-single").select2({dir:'rtl',placeholder: "انتخاب نشده"});
                        },200)
                    }else{
                        data +=`
                        <div class="col-md-6">
                                                    <div class="form-group pt-3">
                                                        <label>`+e.title+`</label>
                                                        <div class="mt-1">
                                                            <label class="switch"><input name="datas[`+e.id+`]" type="hidden" value="0">
                                                                <input name="datas[`+e.id+`]" type="checkbox" checked value="1">
                                                                <span class="slider round"></span>
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                        `
                    }
                })
                $('#dataParent').html(data)
                $('#imgParent').html(imgs)
                setTimeout(function () {
                    $('.dropify').dropify();
                    $('.persianDate').persianDatepicker({
                        autoClose: true,
                        onSelect:function(val){
                            $('.persianDate').val(new persianDate(val).toCalendar('gregorian').toLocale('en').format('YYYY-MM-DD'))
                        },
                        formatter: function(unix){
                            return new persianDate(unix).toCalendar('gregorian').toLocale('en').format('YYYY-MM-DD')
                        }
                    });
                },200)
            })
        }


        if ($("#ul-slider-1").length) {
            var bigValueSlider = document.getElementById('ul-slider-1'),
                bigValueSpan = document.getElementById('huge-value');

            noUiSlider.create(bigValueSlider, {
                start: 100,
                step: 10,
                direction: 'rtl',
                connect: [true, false],
                range: {
                    min: 10,
                    max: 100
                }
            });
            bigValueSlider.noUiSlider.on('update', function(values, handle) {
//                  console.log(range[Math.floor(values);

                bigValueSpan.innerHTML = Math.floor(values);
            });
        }
        if ($("#ul-slider-2").length) {
            var bigValueSlider2 = document.getElementById('ul-slider-2'),
                bigValueSpan2 = document.getElementById('huge2-value');

            noUiSlider.create(bigValueSlider2, {
                start: 100,
                step: 10,
                direction: 'rtl',
                connect: [true, false],
                range: {
                    min: 10,
                    max: 100
                }
            });
            bigValueSlider2.noUiSlider.on('update', function(values, handle) {
//                  console.log(range[Math.floor(values);

                bigValueSpan2.innerHTML = Math.floor(values);
            });
        }
        $('#tags').tagsInput({
            'width': '100%',
            'height': '100%',
            'interactive': true,
            'defaultText': 'اضافه کردن',
            'removeWithBackspace': true,
            'minChars': 0,
            'maxChars': 20, // if not provided there is no limit
            'placeholderColor': '#666666'
        });
    </script>

    <script>
        function myMap() {
            var mapProp= {
                center:new google.maps.LatLng(35.6970118,51.2097354),
                zoom:7,
            };
            var map=new google.maps.Map(document.getElementById("googleMap"),mapProp);
            var marker = new google.maps.Marker({
                position: mapProp.center,
                map: map,
                draggable:true,
            });
            map.addListener('click', function (event) {
                placeMarker(map,marker,event.latLng);
            });
            marker.addListener('dragend',function (event) {
                placeMarker(map,marker,event.latLng)
            })
        }
        function placeMarker(map,marker,location) {
            marker.setPosition(location)
            $('#lat').val(location.lat())
            $('#lng').val(location.lng())
        }
    </script>
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCsT_7eLUr_uriW0-bkVG60zXmDvf2e8fY&callback=myMap"></script>
@endsection