<?php

namespace Modules\Advertisement\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use Modules\Advertisement\Entities\Advertisement;
use Modules\Advertisement\Entities\Experience;
use Yajra\DataTables\Html\Builder;
use Nwidart\Modules\Facades\Module;
use Modules\Core\Http\Controllers\BaseController;
use Yajra\DataTables\DataTables;

class ExperienceController extends BaseController
{
    protected $htmlBuilder;
    public function __construct(Builder $htmlBuilder)
    {
        $this->htmlBuilder = $htmlBuilder;
        $this->htmlBuilder->parameters([
            'paging' => true,
            'searching' => true,
            'info' => false,
            'searchDelay' => 350,
            'language' => [
                'url' => Module::asset('core:datatable.json')
            ],
        ]);
        Parent::__construct();
    }
    public function index(Request $request)
    {
        if ($request->ajax()){
            return DataTables::of(Advertisement::find($request->id)->experience()
                ->select(['experiences.id',DB::raw('concat(users.fname ," ",users.lname) as users_fullname '),'text', 'experiences.created_at', 'experiences.updated_at'])
                ->join('users', 'experiences.user_id', '=', 'users.id'))

                ->addColumn('operation', function($exp) {
                    return parent::redirectAction('delete/'.$exp->id,'حذف','danger');
                })
                ->rawColumns(['operation','status'])
                ->make(true);
        }
        $object = 'گزارشات';
        $html = $this->htmlBuilder
            ->addColumn(['data' =>'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' => 'users_fullname', 'name' => 'users.fname', 'title' => 'نام کاربر'])
            ->addColumn(['data' => 'users_fullname', 'name' => 'users.lname', 'title' => 'نام کاربر','class'=>'d-none'])
            ->addColumn(['data' => 'text', 'name' => 'text', 'title' => 'متن'])
            ->addColumn(['data' => 'created_at', 'name' => 'created_at', 'title' => 'ثبت'])
            ->addColumn(['data' => 'updated_at', 'name' => 'updated_at', 'title' => 'ویرایش'])
            ->addColumn(['data' => 'operation', 'name' => 'operation', 'title' => 'عملیات']);
        return view('core::shared.datatable', compact(['html','object']));
    }

    /**
     * Remove the specified resource from storage.
     * @param Request $request
     * @return Response
     */
    public function destroy(Request $request)
    {
        $pid=Experience::find(($request->id))->experiencable_id;
        Experience::find($request->id)->delete();
        return redirect('admin/advertisement/list/experience/'.$pid);

    }

}


