<?php

namespace Modules\Advertisement\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use Modules\Advertisement\Entities\Advertisement;
use Modules\Advertisement\Entities\Experience;
use Modules\Blog\Entities\Comment;
use Yajra\DataTables\Html\Builder;
use Nwidart\Modules\Facades\Module;
use Modules\Core\Http\Controllers\BaseController;
use Yajra\DataTables\DataTables;

class CommentController extends BaseController
{
    protected $htmlBuilder;
    public function __construct(Builder $htmlBuilder)
    {
        $this->htmlBuilder = $htmlBuilder;
        $this->htmlBuilder->parameters([
            'paging' => true,
            'searching' => true,
            'info' => false,
            'searchDelay' => 350,
            'language' => [
                'url' => Module::asset('core:datatable.json')
            ],
        ]);
        Parent::__construct();
    }
    public function index(Request $request)
    {
        if ($request->ajax()) {
            return DataTables::of(Advertisement::find($request->id)->comments()
                ->select(['comments.id', DB::raw('concat(users.fname ," ",users.lname) as users_fullname '),'comment', 'comments.created_at', 'comments.updated_at'])
                ->join('users', 'comments.user_id', '=', 'users.id'))

                ->addColumn('operation', function($comment) {
                    return parent::redirectAction('delete/'.$comment->id,'حذف','danger');
                })
                ->rawColumns(['operation'])
                ->make(true);
        }
        $object = 'نظرات';
        $html = $this->htmlBuilder
            ->addColumn(['data' =>'id', 'name' => 'id', 'title' => 'شناسه'])
            ->addColumn(['data' => 'users_fullname', 'name' => 'users.fname', 'title' => 'نام کاربر'])
            ->addColumn(['data' => 'users_fullname', 'name' => 'users.lname', 'title' => 'نام کاربر','class'=>'d-none'])
            ->addColumn(['data' => 'comment', 'name' => 'comment', 'title' => 'متن'])
            ->addColumn(['data' => 'created_at', 'name' => 'created_at', 'title' => 'ثبت'])
            ->addColumn(['data' => 'updated_at', 'name' => 'updated_at', 'title' => 'ویرایش'])
            ->addColumn(['data' => 'operation', 'name' => 'operation', 'title' => 'عملیات']);
        return view('core::shared.datatable', compact(['html','object']));
    }
    /**
     * Remove the specified resource from storage.
     * @param Request $request
     * @return Response
     */
    public function destroy(Request $request)
    {
        $pid=Comment::find(($request->id))->commentable_id;
        Comment::find($request->id)->delete();
        return redirect('admin/advertisement/list/comment/'.$pid);

    }
    /**
     * Remove the specified resource from storage.
     * @param \Modules\Advertisement\Http\Requests\Comment $request
     * @return Response
     */
    public function delete(\Modules\Advertisement\Http\Requests\Comment $request)
    {
        Comment::find($request->id)->delete();
        return response()->json([
            'data'  => true,
            'message'=>'ok',
            'status' => 200
        ]);
    }
    /**
     * Store a newly created resource in storage.
     * @param  \Modules\Advertisement\Http\Requests\Comment $request
     * @return Response
     */
    public function store(\Modules\Advertisement\Http\Requests\Comment $request)
    {
        $comment=Advertisement::where('id',$request->id)->comments()->create($request->all());
        $data=Comment::where('id',$comment->id)->with('user','commentable')->first();
        return response()->json([
            'data'  => $data,
            'message'=>'ok',
            'status' => 200
        ]);
    }
    /**
     * Update the specified resource in storage.
     * @param  \Modules\Advertisement\Http\Requests\Comment $request
     * @return Response
     */
    public function update(\Modules\Advertisement\Http\Requests\Comment $request)
    {
        Comment::where('id',$request->id)->update($request->all());
        $data=Comment::where('id',$request->id)->with('user','commentable')->first();
        return response()->json([
            'data'  => $data,
            'message'=>'ok',
            'status' => 200
        ]);
    }
}
