<?php

namespace Modules\Advertisement\Entities;

use Elasticquent\ElasticquentTrait;
use Illuminate\Database\Eloquent\Model;
use Modules\Core\Entities\User;

class Experience extends Model
{
    use ElasticquentTrait;
    protected $fillable = ['experiencable_id','experiencable_type','user_id','text','status'];
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    function experiencable()
    {
        return $this->morphTo('experiencable');
    }
}
