<?php

namespace Modules\Advertisement\Entities;

use Elasticquent\ElasticquentTrait;
use Illuminate\Database\Eloquent\Model;
use Modules\Core\Entities\Attachment;
use Modules\Expert\Entities\Expert;
use Modules\Shop\Entities\Shop;

class Category extends Model
{
    use ElasticquentTrait;

    protected $fillable = ['title','parent_id','time','price','data','limit','upload','created_at','updated_at'];
    protected $hidden = ['created_at','updated_at','time','price','upload','deleted_at'];
    protected $appends = ['attachments','items','subs'];
    public function getAttachmentsAttribute()
    {
        if($this->attachments()){
            return $this->attachments()->orderBy('id','desc')->first();
        }else{
            return [];
        }
    }
    public function getItemsAttribute()
    {
        if($this->items()){
            return $this->items()->get();
        }else{
            return [];
        }
    }
    public function getSubsAttribute()
    {
        if($this->subs()){
            return $this->subs()->get();
        }else{
            return [];
        }
    }
    public function advertisement()
    {
        return $this->hasMany(Advertisement::class, 'category_id');
    }
    function attachments(){
        return $this->morphMany(Attachment::class,'attachmentable');
    }
    function subs(){
        return $this->hasMany(Category::class,'parent_id');
    }
    function items(){
        return $this->hasMany(CategoryItem::class,'category_id');
    }
    public function expert()
    {
        return $this->belongsToMany(Expert::class ,'category_expert');
    }
    public function shop()
    {
        return $this->belongsToMany(Shop::class ,'category_shop');
    }

    public $adminFields=[
        'image'=>[
            'type'=>'photo',
            'fa_name'=>'عکس ',
            'col'=>12,
            'required'=>false,
            'data'=>[]
        ],
        'title'=>[
            'type'=>'string',
            'fa_name'=>'عنوان',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'time'=>[
            'type'=>'string',
            'fa_name'=>'زمان',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'price'=>[
            'type'=>'string',
            'fa_name'=>'قیمت',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'limit'=>[
            'type'=>'string',
            'fa_name'=>'محدودیت تعداد',
            'col'=>6,
            'required'=>true,
            'data'=>[]
        ],
        'upload'=>[
            'type'=>'string',
            'fa_name'=>'محدودیت حجم',
            'col'=>6,
            'required'=>false,
            'data'=>[]
        ],
    ];
}
